<?php
// Conexión a la base de datos
include_once('config/db.php');

// Obtener todas las federaciones
$sql = "SELECT * FROM federaciones";
$stmt = $conn->prepare($sql);
$stmt->execute();
$federaciones = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtener todos los usuarios
$sql = "SELECT * FROM usuarios";
$stmt = $conn->prepare($sql);
$stmt->execute();
$usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Procesar el formulario cuando se envíe
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $usuario_id = $_POST['usuario_id'];
    $federacion_id = $_POST['federacion_id'];

    // Actualizar la federación del usuario
    $sql = "UPDATE usuarios SET federacion_id = :federacion_id WHERE id = :usuario_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':federacion_id', $federacion_id, PDO::PARAM_INT);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->execute();

    echo "Federación asignada correctamente.";
}
?>

<!-- Formulario para asignar federación a un usuario -->
<form action="asignar_federacion.php" method="POST">
    <label for="usuario_id">Seleccionar Usuario:</label>
    <select id="usuario_id" name="usuario_id">
        <?php foreach ($usuarios as $usuario) { ?>
            <option value="<?php echo $usuario['id']; ?>"><?php echo $usuario['usuario']; ?></option>
        <?php } ?>
    </select>
    <br><br>

    <label for="federacion_id">Seleccionar Federación:</label>
    <select id="federacion_id" name="federacion_id">
        <?php foreach ($federaciones as $federacion) { ?>
            <option value="<?php echo $federacion['id']; ?>"><?php echo $federacion['nombre']; ?></option>
        <?php } ?>
    </select>
    <br><br>

    <input type="submit" value="Asignar Federación">
</form>
