<?php

// Verificar si se envió el token de reCAPTCHA
if (isset($_POST['g-recaptcha-response'])) {
    $recaptcha_secret = '6LeCEbMqAAAAAJGbMuhDdIeSoy6zGndk-IRviMJR';
    $recaptcha_response = $_POST['g-recaptcha-response'];

    // Verificar la respuesta con Google
    $url = 'https://www.google.com/recaptcha/api/siteverify';
    $data = [
        'secret' => $recaptcha_secret,
        'response' => $recaptcha_response
    ];

    $options = [
        'http' => [
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    $context  = stream_context_create($options);
    $response = file_get_contents($url, false, $context);
    $response_keys = json_decode($response, true);

    // Validar el score de reCAPTCHA
    $score = $response_keys['score'];
    if ($score < 0.5) {
        $_SESSION['error_msg'] = 'Verificación de reCAPTCHA fallida. Intenta nuevamente.';
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        exit;
    }
} else {
    $_SESSION['error_msg'] = 'No se ha recibido la verificación de reCAPTCHA.';
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;
}






// Configuración de la base de datos
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
 // Esto ya te conecta a la base de datos y guarda la conexión en $conn
require 'admin/config/db.php'; // Esto ya te conecta a la base de datos y guarda la conexión en $conn
require 'vendor/autoload.php';  // Asegúrate de que el path al autoload sea correcto

// Usamos la variable $conn para las consultas


$datos = null;
$show_popup = false;
$modified_data = []; // Array para almacenar los datos modificados
$usuario_registrado = false; // Flag para verificar si el usuario ya está registrado

$stmt_federaciones = $conn->prepare("SELECT id, federacion FROM federaciones WHERE id <> 1");
$stmt_federaciones->execute();
$federaciones = $stmt_federaciones->fetchAll(PDO::FETCH_ASSOC);

                
$stmt_opseguro = $conn->prepare("SELECT opseguro FROM opseguro ORDER BY opseguro ASC");
$stmt_opseguro->execute();
$opseguros = $stmt_opseguro->fetchAll(PDO::FETCH_COLUMN);



$stmt_anios = $conn->prepare("SELECT * FROM anios");
$stmt_anios->execute();
$anios = $stmt_anios->fetch(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar si el documento ya existe en la base de datos
    $documento = $_POST['documento'];
    $stmt = $conn->prepare("SELECT COUNT(*) FROM users WHERE documento = :documento");
    $stmt->execute([':documento' => $documento]);
    $count = $stmt->fetchColumn();
    $fechanac = $_POST['fechanac'];
    $fecha_formateada = date("d/m/Y", strtotime($fechanac)); // Convierte yyyy-mm-dd a dd/mm/yyyy
    $categoria0 = $_POST['categoria0'];
    $categoria1 = isset($_POST['categoria1']) && !empty($_POST['categoria1']) ? $_POST['categoria1'] : null;
    $categoriaConcatenada = $categoria1 ? $categoria0 . ' - ' . $categoria1 : $categoria0;
    $fecha_registro = date("Y-m-d H:i:s");

    if ($count > 0) {
        // Si el documento ya existe, proceder con la actualización
        
        
        $sql = "UPDATE users SET 
                vacunado = :vacunado, 
                peso = :peso, altura = :altura, os = :os, categoria = :categoria, 
                club = :club, ciudad = :ciudad, calle = :calle,
                opseguro = :opseguro, telefono = :telefono, email = :email, emergencia = :emergencia, 
                telemergencia = :telemergencia, emailcontacto = :emailcontacto, licenciaanio = :licenciaanio, lic = :lic, fecha_registro = :fecha_registro 
                WHERE documento = :documento";
    } else {
        // Si no existe, realizar la inserción
        $sql = "INSERT INTO users (documento, uci, Nombre, apellidos, genero, vacunado, peso, altura, os, fechanac, 
                categoria, club, ciudad, calle, nacionalidad, opseguro, telefono, email, emergencia, 
                telemergencia, emailcontacto, licenciaanio, lic, fecha_registro) 
                VALUES (:documento, :uci, :Nombre, :apellidos, :genero, :vacunado, :peso, :altura, :os, :fechanac, 
                :categoria, :club, :ciudad, :calle, :nacionalidad, :opseguro, :telefono, :email, :emergencia, 
                :telemergencia, :emailcontacto, :licenciaanio, :lic, :fecha_registro)";
    }
    
    
    // Preparar la consulta
    $stmt = $conn->prepare($sql);
    
    if ($count > 0) {

    // Ejecutar la consulta con los datos
    $stmt->execute([
        ':documento' => $_POST['documento'],
        ':vacunado' => $_POST['vacunado'],
        ':peso' => $_POST['peso'],
        ':altura' => $_POST['altura'],
        ':os' => $_POST['os'],
        ':categoria' => $categoriaConcatenada,
        ':club' => $_POST['club'],
        ':ciudad' => $_POST['localidad'] . ' - ' . $_POST['provincia'],
        ':calle' => $_POST['calle'],
        ':opseguro' => $_POST['opseguro'],
        ':telefono' => $_POST['telefono'],
        ':email' => $_POST['email'],
        ':emergencia' => $_POST['emergencia'],
        ':telemergencia' => $_POST['telemergencia'],
        ':licenciaanio' => $_POST['licenciaanio'],
        ':emailcontacto' => $_POST['emailcontacto'],
        ':fecha_registro' => $fecha_registro,
        ':lic' => 'Federación pendiente'

    ]);
} else {
    $stmt->execute([
        ':documento' => $_POST['documento'],
        ':uci' => $_POST['uci'],
        ':Nombre' => $_POST['Nombre'],
        ':apellidos' => $_POST['apellidos'],
        ':genero' => $_POST['genero'],
        ':vacunado' => $_POST['vacunado'],
        ':peso' => $_POST['peso'],
        ':altura' => $_POST['altura'],
        ':os' => $_POST['os'],
        ':fechanac' => $fecha_formateada,
        ':categoria' => $categoriaConcatenada,
        ':club' => $_POST['club'],
        ':ciudad' => $_POST['localidad'] . ' - ' . $_POST['provincia'],
        ':calle' => $_POST['calle'],
        ':nacionalidad' => $_POST['nacionalidad'],
        ':opseguro' => $_POST['opseguro'],
        ':telefono' => $_POST['telefono'],
        ':email' => $_POST['email'],
        ':emergencia' => $_POST['emergencia'],
        ':telemergencia' => $_POST['telemergencia'],
        ':licenciaanio' => $_POST['licenciaanio'],
        ':emailcontacto' => $_POST['emailcontacto'],
        ':fecha_registro' => $fecha_registro,
        ':lic' => 'Federación pendiente'
    ]);
}

    
    $labels = [
    'uci' => 'Código UCI',
    'Nombre' => 'Nombre',
    'apellidos' => 'Apellidos',
    'genero' => 'Género',
    'vacunado' => 'Vacunado COVID',
    'peso' => 'Peso',
    'altura' => 'Altura',
    'os' => 'Obra Social',
    'fechanac' => 'Fecha de Nacimiento',
    'categoria' => 'Categoría',
    'club' => 'Club',
    'localidad' => 'Localidad',
    'provincia' => 'Provincia',
    'calle' => 'Calle',
    'nacionalidad' => 'Nacionalidad',
    'opseguro' => 'Operador de Seguro',
    'telefono' => 'Teléfono',
    'email' => 'Email',
    'emergencia' => 'Emergencia',
    'telemergencia' => 'Teléfono de Emergencia',
    'emailcontacto' => 'Email de Contacto',
    'licenciaanio' => 'Licencia Año',
];

    // Almacenar los datos modificados para mostrar en el popup
    $modified_data = [
        'uci' => $_POST['uci'],
        'Nombre' => $_POST['Nombre'],
        'apellidos' => $_POST['apellidos'],
        'genero' => $_POST['genero'],
        'vacunado' => $_POST['vacunado'],
        'peso' => $_POST['peso'],
        'altura' => $_POST['altura'],
        'os' => $_POST['os'],
        'fechanac' => $fecha_formateada,
        'categoria' => $categoriaConcatenada,
        'club' => $_POST['club'],
        'localidad' => $_POST['localidad'],
        'provincia' => $_POST['provincia'],
        'calle' => $_POST['calle'],
        'nacionalidad' => $_POST['nacionalidad'],
        'opseguro' => $_POST['opseguro'],
        'telefono' => $_POST['telefono'],
        'email' => $_POST['email'],
        'emergencia' => $_POST['emergencia'],
        'telemergencia' => $_POST['telemergencia'],
        'licenciaanio' => $_POST['licenciaanio'],
        'emailcontacto' => $_POST['emailcontacto'],

    ];

    // Mostrar el popup después de la modificación
    $show_popup = true;


//EMAIL - no te olvides de arriba
$nombre = $_POST['Nombre'];
$apellidos = $_POST['apellidos'];
$email = $_POST['email'];
$telefono = $_POST['telefono'];
$categoria = $_POST['categoria0'];
$subCategoria = $_POST['categoria1'];
$peso = $_POST['peso'];
$altura = $_POST['altura'];
$vacunado = $_POST['vacunado'];
$club = $_POST['club'];
$localidad = $_POST['localidad'];
$provincia = $_POST['provincia'];
$calle = $_POST['calle'];
$emergencia = $_POST['emergencia'];
$telemergencia = $_POST['telemergencia'];
$emailEmergencia = $_POST['emailcontacto'];
$anio = $_POST['licenciaanio'];
// Crear el mensaje del correo con los valores de los campos
$mensaje = "
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            padding: 20px;
            width: 50%;
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        li {
            margin: 10px 0;
            padding: 10px;
            background-color: #f9f9f9;
            border-radius: 5px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        li:nth-child(even) {
            background-color: #f1f1f1;
        }
        strong {
            color:rgb(63, 105, 150);
        }
    </style>
</head>
<body style='width:50%'>
    <h2>Datos Confirmados:</h2>
    <ul>
        <li><strong>Nombre:</strong> " . htmlspecialchars($nombre) . " " . htmlspecialchars($apellidos) . "</li>
        <li><strong>Email:</strong> " . htmlspecialchars($email) . "</li>
        <li><strong>Teléfono:</strong> " . htmlspecialchars($telefono) . "</li>
        <li><strong>Categoría:</strong> " . htmlspecialchars($categoria) . "</li>
        <li><strong>Subcategoría:</strong> " . htmlspecialchars($subCategoria) . "</li>
        <li><strong>Peso:</strong> " . htmlspecialchars($peso) . "</li>
        <li><strong>Altura:</strong> " . htmlspecialchars($altura) . "</li>
        <li><strong>Vacunado COVID:</strong> " . htmlspecialchars($vacunado) . "</li>
        <li><strong>Club:</strong> " . htmlspecialchars($club) . "</li>
        <li><strong>Localidad:</strong> " . htmlspecialchars($localidad) . "</li>
        <li><strong>Provincia:</strong> " . htmlspecialchars($provincia) . "</li>
        <li><strong>Calle:</strong> " . htmlspecialchars($calle) . "</li>
        <li><strong>Emergencia:</strong> " . htmlspecialchars($emergencia) . "</li>
        <li><strong>Teléfono Emergencia:</strong> " . htmlspecialchars($telemergencia) . "</li>
        <li><strong>Email Emergencia:</strong> " . htmlspecialchars($emailEmergencia) . "</li>
    </ul>
</body>
</html>";



try {
    
       // Crear una instancia de PHPMailer
       $mail = new PHPMailer(true); 

       // Configuración del servidor SMTP
       $mail->isSMTP();  // Configurar el correo para usar SMTP
       $mail->Host = 'ci1.toservers.com';  // Servidor SMTP (en este caso Gmail)
       $mail->Username = 'licenciamiento@ciclismoarg.com';  // Tu correo de Gmail
       $mail->Password = 'r3aBxFPf&M26';  // Tu contraseña de Gmail (o usar "contraseñas de aplicaciones" si tienes habilitada la verificación en dos pasos)
       $mail->SMTPSecure = 'ssl'; 
       $mail->SMTPAuth = true;     
       $mail->Port = 465;  //o 465    
       $mail->CharSet = 'UTF-8';
       // Remitente y destinatario
       $mail->setFrom('licenciamiento@ciclismoarg.com', htmlspecialchars('Federación Ciclista Argentina'));
       $mail->addAddress($email, $nombre); // Agregar un destinatario
       $mail->addReplyTo('licenciamiento@ciclismoarg.comci1.toservers.com', htmlspecialchars('Federación Ciclista Argentina'));  // Responder a este correo (opcional)

    // Contenido del correo
    $mail->isHTML(true);  // Establecer el formato de correo a HTML
    $mail->Subject = htmlspecialchars('Inscripción confirmada - ' . $anio);
    $mail->Body    = '            <img src="https://ciclismoarg.com.ar/licencias/logo2.jpeg" alt="Logo" height="150">

    <br style="margin-top:20px">
    <h3>La inscripción al año ' . $anio . ' fue registrada con éxito.</h3>
    <br style="margin-top:20px">
    <p>Verifique los datos abajo mostrados y contacte a su federación para continuar el trámite. En caso de ser necesario, solicite rectificación de los datos.</p>
    <br style="margin-top:20px">'
    . $mensaje .
    '<br style="margin-top:20px">
    <img src="https://ciclismoarg.com.ar/licencias/logo2.jpeg" alt="Logo" height="150">
    ';
    $mail->AltBody = strip_tags($mensaje);

    // Enviar el correo
    if ($mail->send()) {
        echo 'El mensaje ha sido enviado con éxito';
    } else {
        echo 'No se pudo enviar el mensaje.';
    }
} catch (Exception $e) {
    // Si ocurre algún error
    echo "El mensaje no pudo ser enviado. Error: {$mail->ErrorInfo}";
}



}






// Acción de recuperar datos según el documento
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['documento'])) {
    // Recuperar el valor de documento
    $documento = trim($_GET['documento']);  // Eliminar espacios innecesarios

    // Recuperar datos desde la base de datos
    $stmt = $conn->prepare("SELECT * FROM users WHERE documento = :documento");
    $stmt->execute([':documento' => $documento]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);




    if ($user) {
        // Verificar si el valor de licenciaanio coincide con la tabla anios
        $stmt_licencia = $conn->prepare("SELECT * FROM anios WHERE licenciaanio = :licenciaanio");
        $stmt_licencia->execute([':licenciaanio' => $user['licenciaanio']]);
        $licencia = $stmt_licencia->fetch(PDO::FETCH_ASSOC);

        if ($licencia) {
            // Si la licencia coincide, mostrar mensaje y no mostrar formulario
            $usuario_registrado = true;
            $datos = null;  // No se necesitan los datos del usuario si ya está registrado
        } else {
            $datos = $user;
        }
    } else {
        $datos = null;
    }
}


?>