<?php
include('formulario_data.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>

<!DOCTYPE html>
<html lang="es">
   
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="config/stylesform.css?id=1234">
    <link rel="stylesheet" type="text/css" href="config/styles.css?id=1234">
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <script src="config/scripts.js" defer></script>
    <title>Formulario de Inscripción</title>
    <style>
    /* Popup */
.popup {
display: <?= $show_popup ? 'block' : 'none' ?>;
position: fixed;
top: 50%;
left: 50%;
transform: translate(-50%, -50%);
background-color: #fff;
padding: 20px;
border-radius: 8px;
box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
max-width: 80%;  /* Ajuste para que el tamaño máximo sea el 80% de la pantalla */
width: 80%;      /* Ajuste para que el popup ocupe el 80% de la pantalla */
max-height: 80vh;  /* Ajuste para que el popup no supere el 80% de la altura de la pantalla */
height: 80vh;      /* Ajuste para que el popup ocupe el 80% de la altura de la pantalla */
overflow-y: auto;  /* Permite el desplazamiento vertical si el contenido es demasiado grande */
z-index: 200;
}
</style>

</head>
<header>


                <img src="https://ciclismoarg.com.ar/licencias/logo2.jpeg" alt="Logo" height="50">
                <h1>Formulario de Inscripción</h1>


    </header>
<body>
<div class="busqueda">
    <div class="search-container">
        <form method="GET" action="">
            <label for="documento">Ingrese su Documento:</label>
            <input type="text" id="documento" name="documento" required pattern="^\d{7,8}$" 
            title="Debe ingresar 7 o 8 dígitos numéricos.">
            <button type="submit">Buscar</button>
        </form>
    </div>
</div>
<div class="formdiv">
    <div class="form-container">
        <div class="container">
            <h1>Formulario de Inscripción Corredores <?php echo htmlspecialchars($anios["licenciaanio"]); ?></h1>
<hr>
<?php
if (empty($documento)): ?>
        <h5>Ingrese un documento para empezar</h5>
<?php else: ?>
    <?php
if ($usuario_registrado): ?>

    <p>Usted ya se encuentra registrado para el año <?php echo htmlspecialchars($anios['licenciaanio']); ?>.</p>


        <?php elseif (isset($_GET['documento']) && $datos): 
                $fechaNacimiento = new DateTime(substr($datos['fechanac'], -4) . '-01-01');
                $anioLicencia = new DateTime($anios['licenciaanio'] . '-01-01');
                $edadAnios = $anioLicencia->diff($fechaNacimiento)->y;
                
                $stmt_categorias = $conn->prepare("
                    SELECT categoria 
                    FROM categorias0 
                    WHERE genero = :genero 
                    AND :edadAnios BETWEEN anios_desde AND anios_hasta
                ");

                $stmt_categorias->bindParam(':genero', $datos['genero'], PDO::PARAM_STR);
                $stmt_categorias->bindParam(':edadAnios', $edadAnios, PDO::PARAM_INT);
                $stmt_categorias->execute();
                $categorias0 = $stmt_categorias->fetchAll(PDO::FETCH_COLUMN);

                
                $categoriaactual1 = htmlspecialchars(explode(' - ', $datos['categoria'])[1] ?? '');
                

                ?>

            <!-- Mostrar formulario de edición si el documento existe en la base de datos -->

                            <form id="reinscripcion" method="POST" action="">

                                <input type="hidden" name="documento" value="<?= htmlspecialchars($datos['documento']) ?>">
                                    <div class="seccion">
                                    <h3> Datos del solicitante </h3>
                                    <div class="form-row">
                                            <div>
                                                <label for="licenciaanio">Licencia Año:</label>
                                                <input type="text" id="licenciaanio" name="licenciaanio" value="<?= htmlspecialchars($anios['licenciaanio']) ?>" readonly>
                                            </div>
                                            <div>
                                                <label for="uci">Código UCI:</label>
                                                <input type="text" id="uci" name="uci" value="<?= htmlspecialchars($datos['uci']) ?>" readonly>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="Nombre">Nombre:</label>
                                                <input type="text" id="Nombre" name="Nombre" value="<?= htmlspecialchars($datos['Nombre']) ?>" readonly>
                                            </div>
                                            <div>
                                                <label for="apellidos">Apellido:</label>
                                                <input type="text" id="apellidos" name="apellidos" value="<?= htmlspecialchars($datos['apellidos']) ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div>
                                                <label for="genero">Género:</label>
                                                <input type="text" id="genero" name="genero" value="<?= htmlspecialchars($datos['genero']) ?>" readonly>
                                            </div>
                                            <div>
                                                <label for="fechanac">Fecha de Nacimiento:</label>
                                                <input type="date" id="fechanac" name="fechanac" value="<?= date('Y-m-d', strtotime($datos['fechanac'])) ?>" readonly>
                                            </div>
                                            <div>
                                        <label for="edadanios">Edad en Años:</label>
                                        <input type="text" id="edadanios" name="edadanios" value="<?= htmlspecialchars($edadAnios) ?>" readonly>
                                    </div>
                                    <div>
                                                <label for="nacionalidad">Nacionalidad:</label>
                                                <input type="text" id="nacionalidad" name="nacionalidad" value="<?= htmlspecialchars($datos['nacionalidad']) ?>" readonly>
                                                    </div>
                                                    
                                        </div>
                                                </div>
                                                <hr>
                                        <div class="seccion">
                                    <h3> Actualización de datos </h3>
                                        <div class="form-row">
                                            <div>
                                                <label for="peso">Peso (Unidad Kgs. [000.00]):</label>
                                                <input type="number" id="peso" name="peso" step="0.01" value="<?= htmlspecialchars($datos['peso']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="altura">Altura (Centimetros [000]):</label>
                                                <input type="number" id="altura" name="altura" value="<?= htmlspecialchars($datos['altura']) ?>" required>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="os">Obra Social:</label>
                                                <input type="text" id="os" name="os" value="<?= htmlspecialchars($datos['os']) ?>" required>
                                            </div>

                                            <div>
                                                <label for="vacunado">Vacunado COVID:</label>
                                                <select id="vacunado" name="vacunado" required>
                                                <option value="" <?= !isset($datos['vacunado']) || $datos['vacunado'] === '' ? 'selected' : '' ?>>Seleccione una opción</option>
                                                <option value="SI" <?= $datos['vacunado'] === 'SI' ? 'selected' : '' ?>>Sí</option>
                                                <option value="NO" <?= $datos['vacunado'] === 'NO' ? 'selected' : '' ?>>No</option>
                                                </select>
                                            </div>
                                        </div>


                                        <div class="form-row">
                                            <div>
                                                <label for="club">Club:</label>
                                                <input type="text" id="club" name="club" value="<?= htmlspecialchars($datos['club']) ?>">
                                            </div>
                                            <div>
                                                <label for="opseguro">Operador de Seguro:</label>
                                                    <select id="opseguro" name="opseguro" required>
                                                        <?php foreach ($opseguros as $opseguro) {
                                                            $opseguroselected = $datos['opseguro'] ?? '';
                                                            $selected = $opseguro === $datos['opseguro'] ? 'selected' : '';
                                                            echo "<option value=\"$opseguro\" $selected>$opseguro</option>";
                                                        }
                                                        ?>
                                                    </select>
                                            </div>
                                        </div>

                                        </div>

                                        <div class="form-row">
                                        <div>
                                            <label for="categoria0">Categoría:</label>
                                            <select id="categoria0" name="categoria0" required>
                                                <option value="">Seleccione una categoría</option>
                                                <?php
                                                // Obtener la categoría actual si existe
                                                $categoriaactual = htmlspecialchars(explode(' - ', $datos['categoria'])[0] ?? '');

                                                // Generar las opciones del select
                                                foreach ($categorias0 as $categoria0) {
                                                    $selected = $categoria0 === $categoriaactual ? 'selected' : '';
                                                    echo "<option value=\"$categoria0\" $selected>$categoria0</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                            <div>
                                            <label for="categoria1">Sub Categoría:</label>
                                            <input type="hidden" id="cate1actual" value="<?php echo htmlspecialchars(explode(' - ', $datos['categoria'])[1] ?? ''); ?>">
                                            <select id="categoria1" name="categoria1">
                                                <option value="">Seleccione una subcategoría</option>
                                            </select>
                                            </div>
                                    
                                    </div>
                                    <hr>
                                        <div class="subseccion">
                                            <h4>Información de Contacto</h4>
                                        <div class="form-row">
                                            <div>
                                                <label for="localidad">Localidad:</label>
                                                <input type="text" id="localidad" name="localidad" value="<?= htmlspecialchars(explode(' - ', $datos['ciudad'])[0]) ?>" required>
                                            </div>
                                    <div>
                                        <label for="provincia">Provincia:</label>
                                        <select id="provincia" name="provincia" required>
                                            <option value="">Seleccione una provincia</option>
                                            <?php
                                            // Lista de provincias de Argentina
                                            $provincias = [
                                                'CABA', 'Buenos Aires', 'Catamarca', 'Chaco', 'Chubut', 'Córdoba', 'Corrientes', 
                                                'Entre Ríos', 'Formosa', 'Jujuy', 'La Pampa', 'La Rioja', 'Mendoza', 
                                                'Misiones', 'Neuquén', 'Río Negro', 'Salta', 'San Juan', 'San Luis', 
                                                'Santa Cruz', 'Santa Fe', 'Santiago del Estero', 'Tierra del Fuego', 'Tucumán'
                                            ];
                                            $provincias = array_map('strtoupper', $provincias);

                                            // Obtener la provincia seleccionada si existe
                                            $provinciaSeleccionada = htmlspecialchars(explode(' - ', $datos['ciudad'])[1] ?? '');

                                            // Generar las opciones del select
                                            foreach ($provincias as $provincia) {
                                                $selected = $provincia === $provinciaSeleccionada ? 'selected' : '';
                                                echo "<option value=\"$provincia\" $selected>$provincia</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="calle">Calle:</label>
                                                <input type="text" id="calle" name="calle" value="<?= htmlspecialchars($datos['calle']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="telefono">Teléfono: (sin 0 ni 15)</label>
                                                <input type="text" id="telefono" name="telefono" value="<?= htmlspecialchars($datos['telefono']) ?>" required>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="email">Email:</label>
                                                <input type="email" id="email" name="email" value="<?= htmlspecialchars($datos['email']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="emergencia">Nombre contacto de emergencia:</label>
                                                <input type="text" id="emergencia" name="emergencia" value="<?= htmlspecialchars($datos['emergencia']) ?>" required>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="telemergencia">Teléfono de Emergencia:</label>
                                                <input type="text" id="telemergencia" name="telemergencia" value="<?= htmlspecialchars($datos['telemergencia']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="emailcontacto">Email de Contacto de emergencia: (sin 0 ni 15)</label>
                                                <input type="email" id="emailcontacto" name="emailcontacto" value="<?= htmlspecialchars($datos['emailcontacto']) ?>" required>
                                            </div>
                                        </div>


                                                    <div class="button-container">
                                                        <button type="submit">ENVIAR REGISTRO</button>
                                                    </div>
                            </form>

        <?php elseif (!$datos): ?>
            <div>
        <p style="display: inline;">DNI <p style="font-size:1.5em;font-weight:700;display: inline;""><?= htmlspecialchars($_GET['documento']) ?></p> no registrado.</p>
        </div>


  <button id="registro0" onclick="mostrarFormulario()">INICIAR REGISTRO</button>
<form id="formularioRegistro" class="hidden" method="POST" action="">


<input type="hidden" name="uci" value="">
<div class="seccion">
<h3> Datos del solicitante </h3>
 <div class="form-row">
       <div>
           <label for="licenciaanio">Licencia Año:</label>
           <input type="text" id="licenciaanio" name="licenciaanio" value="<?= htmlspecialchars($anios['licenciaanio']) ?>" readonly>
       </div>
       <div>
       <label for="documento">Documento:</label>

       <input type="text" name="documento" min-length:7 value="<?= htmlspecialchars($_GET['documento']) ?>" readonly>
       </div>
   </div>

   <div class="form-row">
       <div>
           <label for="Nombre">Nombre:</label>
           <input type="text" id="Nombre" name="Nombre" value="" required>
       </div>
       <div>
           <label for="apellidos">Apellido:</label>
           <input type="text" id="apellidos" name="apellidos" value="" requiered>
       </div>

   </div>
   <div class="form-row">
       <div>
           <label for="genero">Género:</label>
           <select id="genero" name="genero" onchange="calcularEdad()" required>
               <option value="M" >Masculino</option>
               <option value="F" >Femenino</option>
           </select>
       </div>
       <div>
           <label for="fechanac">Fecha de Nacimiento:</label>
           <input type="date" id="fechanac" name="fechanac" value="" onchange="calcularEdad()" required>
       </div>
       <div>
   <label for="edadanios">Edad en Años:</label>
   
   <input type="text" id="edadanios" name="edadanios" value="" readonly>
        </div>
        <div>
    <label for="nacionalidad">Nacionalidad:</label>
       <select id="nacionalidad" name="nacionalidad" value="" required>                                
       <option class="" value="AFG" >Afganistan</option>
       <option class="" value="ARG" selected >Argentina</option>
       <option class="" value="ALB" >Albania</option>
       <option class="" value="DEU" >Alemania</option>
       <option class="" value="DZA" >Algeria</option>
       <option class="" value="AND" >Andorra</option>
       <option class="" value="AGO" >Angola</option>
       <option class="" value="AIA" >Anguila</option>
       <option class="" value="ATA" >Antartida</option>
       <option class="" value="ATG" >Antigua y Barbuda</option>
       <option class="" value="SAU" >Arabia Saudita</option>
       <option class="" value="ARM" >Armenia</option>
       <option class="" value="ABW" >Aruba</option>
       <option class="" value="AUS" >Australia</option>
       <option class="" value="AUT" >Austria</option>
       <option class="" value="AZE" >Azerbaiyan</option>
       <option class="" value="BEL" >Belgica</option>
       <option class="" value="BHS" >Bahamas</option>
       <option class="" value="BHR" >Bahrein</option>
       <option class="" value="BGD" >Bangladesh</option>
       <option class="" value="BRB" >Barbados</option>
       <option class="" value="BLZ" >Belice</option>
       <option class="" value="BEN" >Benin</option>
       <option class="" value="BTN" >Bhutan</option>
       <option class="" value="BLR" >Bielorrusia</option>
       <option class="" value="MMR" >Birmania</option>
       <option class="" value="BOL" >Bolivia</option>
       <option class="" value="BIH" >Bosnia y Herzegovina</option>
       <option class="" value="BWA" >Botsuana</option>
       <option class="" value="BRA" >Brasil</option>
       <option class="" value="BRN" >Brunei</option>
       <option class="" value="BGR" >Bulgaria</option>
       <option class="" value="BFA" >Burkina Faso</option>
       <option class="" value="BDI" >Burundi</option>
       <option class="" value="CPV" >Cabo Verde</option>
       <option class="" value="KHM" >Camboya</option>
       <option class="" value="CMR" >Camerun</option>
       <option class="" value="CAN" >Canada</option>
       <option class="" value="QAT" >Catar</option>
       <option class="" value="TCD" >Chad</option>
       <option class="" value="CHL" >Chile</option>
       <option class="" value="CHN" >China</option>
       <option class="" value="CYP" >Chipre</option>
       <option class="" value="COL" >Colombia</option>
       <option class="" value="COM" >Comoras</option>
       <option class="" value="COG" >Congo</option>
       <option class="" value="CRI" >Costa Rica</option>
       <option class="" value="CIV" >Costa de Marfil</option>
       <option class="" value="HRV" >Croacia</option>
       <option class="" value="CUB" >Cuba</option>
       <option class="" value="DNK" >Dinamarca</option>
       <option class="" value="DMA" >Dominica</option>
       <option class="" value="ECU" >Ecuador</option>
       <option class="" value="EGY" >Egipto</option>
       <option class="" value="SLV" >El Salvador</option>
       <option class="" value="ARE" >Emiratos Árabes Unidos</option>
       <option class="" value="ERI" >Eritrea</option>
       <option class="" value="SVK" >Eslovaquia</option>
       <option class="" value="SVN" >Eslovenia</option>
       <option class="" value="ESP" >España</option>
       <option class="" value="USA" >Estados Unidos</option>
       <option class="" value="EST" >Estonia</option>
       <option class="" value="ETH" >Etiopía</option>
       <option class="" value="PHL" >Filipinas</option>
       <option class="" value="FIN" >Finlandia</option>
       <option class="" value="FJI" >Fiyi</option>
       <option class="" value="FRA" >Francia</option>
       <option class="" value="GAB" >Gabón</option>
       <option class="" value="GMB" >Gambia</option>
       <option class="" value="GEO" >Georgia</option>
       <option class="" value="GHA" >Ghana</option>
       <option class="" value="GIB" >Gibraltar</option>
       <option class="" value="GRD" >Granada</option>
       <option class="" value="GRC" >Grecia</option>
       <option class="" value="GRL" >Groenlandia</option>
       <option class="" value="GTM" >Guatemala</option>
       <option class="" value="GUY" >Guyana</option>
       <option class="" value="HTI" >Haití</option>
       <option class="" value="HND" >Honduras</option>
       <option class="" value="HUN" >Hungría</option>
       <option class="" value="IND" >India</option>
       <option class="" value="IDN" >Indonesia</option>
       <option class="" value="IRQ" >Irak</option>
       <option class="" value="IRN" >Irán</option>
       <option class="" value="IRL" >Irlanda</option>
       <option class="" value="ISL" >Islandia</option>
       <option class="" value="ISR" >Israel</option>
       <option class="" value="ITA" >Italia</option>
       <option class="" value="JAM" >Jamaica</option>
       <option class="" value="JPN" >Japón</option>
       <option class="" value="JOR" >Jordania</option>
       <option class="" value="KAZ" >Kazajistán</option>
       <option class="" value="KEN" >Kenia</option>
       <option class="" value="KGZ" >Kirguistán</option>
       <option class="" value="KIR" >Kiribati</option>
       <option class="" value="KWT" >Kuwait</option>
       <option class="" value="LAO" >Laos</option>
       <option class="" value="LSO" >Lesoto</option>
       <option class="" value="LVA" >Letonia</option>
       <option class="" value="LBN" >Líbano</option>
       <option class="" value="LBR" >Liberia</option>
       <option class="" value="LBY" >Libia</option>
       <option class="" value="LIE" >Liechtenstein</option>
       <option class="" value="LTU" >Lituania</option>
       <option class="" value="LUX" >Luxemburgo</option>
       <option class="" value="MDG" >Madagascar</option>
       <option class="" value="MYS" >Malasia</option>
       <option class="" value="MWI" >Malaui</option>
       <option class="" value="MDV" >Maldivas</option>
       <option class="" value="MLI" >Malí</option>
       <option class="" value="MLT" >Malta</option>
       <option class="" value="MAR" >Marruecos</option>
       <option class="" value="MHL" >Islas Marshall</option>
       <option class="" value="MRT" >Mauritania</option>
       <option class="" value="MUS" >Mauricio</option>
       <option class="" value="MEX" >México</option>
       <option class="" value="FSM" >Micronesia</option>
       <option class="" value="MDA" >Moldavia</option>
       <option class="" value="MCO" >Mónaco</option>
       <option class="" value="MNG" >Mongolia</option>
       <option class="" value="MNE" >Montenegro</option>
       <option class="" value="MOZ" >Mozambique</option>
       <option class="" value="NAM" >Namibia</option>
       <option class="" value="NRU" >Nauru</option>
       <option class="" value="NPL" >Nepal</option>
       <option class="" value="NIC" >Nicaragua</option>
       <option class="" value="NER" >Níger</option>
       <option class="" value="NGA" >Nigeria</option>
       <option class="" value="NOR" >Noruega</option>
       <option class="" value="NZL" >Nueva Zelanda</option>
       <option class="" value="OMN" >Omán</option>
       <option class="" value="NLD" >Países Bajos</option>
       <option class="" value="PAK" >Pakistán</option>
       <option class="" value="PLW" >Palaos</option>
       <option class="" value="PAN" >Panamá</option>
       <option class="" value="PNG" >Papúa Nueva Guinea</option>
       <option class="" value="PRY" >Paraguay</option>
       <option class="" value="PER" >Perú</option>
       <option class="" value="POL" >Polonia</option>
       <option class="" value="PRT" >Portugal</option>
       <option class="" value="QAT" >Catar</option>
       <option class="" value="GBR" >Reino Unido</option>
       <option class="" value="CAF" >República Centroafricana</option>
       <option class="" value="CZE" >República Checa</option>
       <option class="" value="DOM" >República Dominicana</option>
       <option class="" value="ROU" >Rumania</option>
       <option class="" value="RUS" >Rusia</option>
       <option class="" value="RWA" >Ruanda</option>
       <option class="" value="WSM" >Samoa</option>
       <option class="" value="SMR" >San Marino</option>
       <option class="" value="VCT" >San Vicente y las Granadinas</option>
       <option class="" value="LCA" >Santa Lucía</option>
       <option class="" value="STP" >Santo Tomé y Príncipe</option>
       <option class="" value="SEN" >Senegal</option>
       <option class="" value="SRB" >Serbia</option>
       <option class="" value="SYC" >Seychelles</option>
       <option class="" value="SLE" >Sierra Leona</option>
       <option class="" value="SGP" >Singapur</option>
       <option class="" value="SYR" >Siria</option>
       <option class="" value="SOM" >Somalia</option>
       <option class="" value="LKA" >Sri Lanka</option>
       <option class="" value="ZAF" >Sudáfrica</option>
       <option class="" value="SDN" >Sudán</option>
       <option class="" value="SSD" >Sudán del Sur</option>
       <option class="" value="SWE" >Suecia</option>
       <option class="" value="CHE" >Suiza</option>
       <option class="" value="SUR" >Surinam</option>
       <option class="" value="THA" >Tailandia</option>
       <option class="" value="TWN" >Taiwán</option>
       <option class="" value="TZA" >Tanzania</option>
       <option class="" value="TJK" >Tayikistán</option>
       <option class="" value="TLS" >Timor Oriental</option>
       <option class="" value="TGO" >Togo</option>
       <option class="" value="TON" >Tonga</option>
       <option class="" value="TTO" >Trinidad y Tobago</option>
       <option class="" value="TUN" >Túnez</option>
       <option class="" value="TKM" >Turkmenistán</option>
       <option class="" value="TUR" >Turquía</option>
       <option class="" value="TUV" >Tuvalu</option>
       <option class="" value="UKR" >Ucrania</option>
       <option class="" value="UGA" >Uganda</option>
       <option class="" value="URY" >Uruguay</option>
       <option class="" value="UZB" >Uzbekistán</option>
       <option class="" value="VUT" >Vanuatu</option>
       <option class="" value="VAT" >Ciudad del Vaticano</option>
       <option class="" value="VEN" >Venezuela</option>
       <option class="" value="VNM" >Vietnam</option>
       <option class="" value="YEM" >Yemen</option>
       <option class="" value="DJI" >Yibuti</option>
       <option class="" value="ZMB" >Zambia</option>
       <option class="" value="ZWE" >Zimbabue</option>
       </select>
               </div>
               
   </div>
           </div>
           <hr>
<div class="seccion">
            <h3> Actualización de datos </h3>
            <div class="form-row">
                <div>
                    <label for="peso">Peso (Unidad Kgs. [000.00]):</label>
                    <input type="text" id="peso" name="peso" pattern="^\d{3}\.\d{2}$" value="" required>
                </div>
                <div>
                    <label for="altura">Altura (Centimetros [000]):</label>
                    <input type="text" id="altura" name="altura" pattern="^\d{3}$" value="" required>
                </div>
            </div>

            <div class="form-row">
                <div>
                    <label for="os">Obra Social:</label>
                    <input type="text" id="os" name="os" value="" required>
                </div>

                <div>
                    <label for="vacunado">Vacunado COVID:</label>
                    <select id="vacunado" name="vacunado" required>
                    <option value="">Seleccione una opción</option>
                    <option value="SI" >Sí</option>
                    <option value="NO" >No</option>
                    </select>
                </div>
            </div>


   <div class="form-row">
   <div>
                                                <label for="club">Club:</label>
                                                <input type="text" id="club" name="club" required>
                                            </div>
                                            <div>
                                                <label for="opseguro">Operador de Seguro:</label>
                                                    <select id="opseguro" name="opseguro" required>
                                                        <?php foreach ($opseguros as $opseguro) {

                                                            echo "<option value=\"$opseguro\" $selected>$opseguro</option>";
                                                        }
                                                        ?>
                                                    </select>
                                            </div>

      </div>

   <div class="form-row">
   <div>
       <label for="categoria0">Categoría:</label>
       <select id="categoria0" name="categoria0" required>
           <option value="">Seleccione una categoría</option>
           <?php


           // Generar las opciones del select
           foreach ($categorias0 as $categoria0) {
               $selected = $categoria0 === $categoriaactual ? 'selected' : '';
               echo "<option value=\"$categoria0\" $selected>$categoria0</option>";
           }
           ?>
       </select>
   </div>
       <div>
       <label for="categoria1">Sub Categoría:</label>
       <select id="categoria1" name="categoria1" >
           <option value="">Seleccione una subcategoría</option>
       </select>
       </div>
       </div>


<hr>
   <div class="subseccion">
       <h4>Información de Contacto</h4>
   <div class="form-row">
       <div>
           <label for="localidad">Localidad:</label>
           <input type="text" id="localidad" name="localidad" value="" required>
       </div>
<div>
   <label for="provincia">Provincia:</label>
   <select id="provincia" name="provincia" required>
       <option value="">Seleccione una provincia</option>
       <?php
       // Lista de provincias de Argentina
       $provincias = [
           'CABA', 'Buenos Aires', 'Catamarca', 'Chaco', 'Chubut', 'Córdoba', 'Corrientes', 
           'Entre Ríos', 'Formosa', 'Jujuy', 'La Pampa', 'La Rioja', 'Mendoza', 
           'Misiones', 'Neuquén', 'Río Negro', 'Salta', 'San Juan', 'San Luis', 
           'Santa Cruz', 'Santa Fe', 'Santiago del Estero', 'Tierra del Fuego', 'Tucumán'
       ];
       $provincias = array_map('strtoupper', $provincias);


       // Generar las opciones del select
       foreach ($provincias as $provincia) {

           echo "<option value=\"$provincia\">$provincia</option>";
       }
       ?>
   </select>
</div>
   </div>

   <div class="form-row">
       <div>
           <label for="calle">Calle:</label>
           <input type="text" id="calle" name="calle" value="" required>
       </div>
       <div>
           <label for="telefono">Teléfono:</label>
           <input type="text" id="telefono" name="telefono" pattern="^\d{10}$" placeholder="Sin 0 ni 15) value="" required>
       </div>
   </div>

   <div class="form-row">
       <div>
           <label for="email">Email:</label>
           <input type="email" id="email" name="email" value="" required>
       </div>
       <div>
           <label for="emergencia">Emergencia:</label>
           <input type="text" id="emergencia" name="emergencia" value="" required>
       </div>
   </div>

   <div class="form-row">
       <div>
           <label for="telemergencia">Teléfono de Emergencia:</label>
           <input type="text" id="telemergencia" name="telemergencia" pattern="^\d{10}$" placeholder="Sin 0 ni 15" value="" required>
       </div>
       <div>
           <label for="emailcontacto">Email de Contacto:</label>
           <input type="email" id="emailcontacto" name="emailcontacto" value="" required>
       </div>
   </div>


               <div class="button-container">
                   <button type="submit">ENVIAR REGISTRO</button>
               </div>
    </form>


        </div>
         
        <?php endif; ?>
        <?php endif; ?>

        </div>
    </div>

    <!-- Popup con los cambios realizados -->
    <div class="popup">
        <h2>CORREDOR REGISTRADO CORRECTAMENTE</h2>
        <div class="popup-content">
            <?php
            foreach ($modified_data as $field => $value) {
        echo "<p><strong>" . $labels[$field] . ":</strong> $value</p>";
            }
            ?>
        </div>
        <button onclick="window.location.href='formulario.php'">Volver al Formulario</button>
    </div>


</body>
</html>