<?php
// Incluye la biblioteca TCPDF
require_once('tcpdf/tcpdf.php');
require 'pdf147.php';
// Crea una instancia de la clase TCPDF
$pdf = new TCPDF();

// Establece el formato del papel y la orientación
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->AddPage();

// Define el contenido que deseas codificar en el código PDF417
$contenido = "Hola, esto es un código PDF417 de ejemplo.";
$tamanio_codigo = 120;
$pdf->write2DBarcode($contenido, 'PDF417', 10, 10, $tamanio_codigo, $tamanio_codigo);

// Ajusta la resolución del PDF (aumenta la calidad de la imagen)
$pdf->setJPEGQuality(95);

// Almacena el contenido del PDF en una variable
$contenido_pdf = $pdf->Output('imagen.pdf', 'S');

// Convierte el contenido PDF a una imagen PNG utilizando Imagick
$image = new Imagick();
$image->readImageBlob($contenido_pdf);
$image->setImageFormat("png");

// Guarda el contenido de la imagen en un archivo en el servidor
$nombre_archivo = 'fotos/imagen.png';
file_put_contents($nombre_archivo, $image);

// Muestra un mensaje si la operación de guardar fue exitosa
if (file_exists($nombre_archivo)) {
    echo "La imagen se ha guardado correctamente en el servidor.";
} else {
    echo "Error al intentar guardar la imagen en el servidor.";
}

// Limpia la memoria
$image->clear();
?>
