<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once('admin/config/db.php');

// Obtener el nivel de acceso del usuario
include('header_home.php');
include('admin/licenciados_data.php');


?>


<!DOCTYPE html>
<html lang="es">
<head>

    <meta charset="UTF-8">
    <title>Bienvenido</title>
    <script src="https://kit.fontawesome.com/ad1090de93.js" crossorigin="anonymous"></script>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="admin/styles.css?id=1234">
    <link rel="stylesheet" type="text/css" href="admin/stylesform.css?id=1234">
    <script src="https://cdn.jsdelivr.net/npm/@zxing/library@0.18.4/umd/index.min.js"></script>
    <script src="admin/config/scripts.js" ></script>

    <style>
        .bread {
    margin-left: 15%;
}
    video {
            margin-top: 40px;
        width: 300px;
    height: 100px;
    content: stretch;
    object-fit: cover;
    display:none;
    }
    .buscalic {
        display: flex
;
    flex-direction: row;
    flex-wrap: nowrap;
    align-items: flex-start;
    justify-content: center;
    }
    .buscalic1 {
    display: flex
;
    flex-direction: row;
    justify-content: flex-end;
    flex-wrap: wrap;
    align-content: flex-end;
    align-items: center;
    margin-bottom: 20px;
}
    
        .ios-switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
            scale: .75;
        }

        .ios-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: 0.4s;
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            border-radius: 50%;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: 0.4s;
        }

        input:checked + .slider {
            background-color: #4CAF50;
        }

        input:checked + .slider:before {
            transform: translateX(26px);
        }

@media (max-width: 767px) {
    .bread {
        margin-left: 5%;
    }
}
       tr, th {
    text-align: left;
} 
          @media (max-width: 768px) {
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }



}
        </style>

</head>
<body>

    <main class="contenedor">

        <?php if (isset($_SESSION['usuario_id'])): ?>
                <div class="buscalic1">
                    <label for="disponibilidad">Mostrar sólo mis federados</label>
                            <input type="hidden" id="feduser" value="<?php echo htmlspecialchars($federacion_usuario); ?>">

    <label class="ios-switch">
        <input type="checkbox" id="disponibilidad" checked>
        <span class="slider"></span>
    </label>
</div>
<?php endif; ?>
        <h2 id="titulo">Licenciados</h2>
        <div class="buscalic">
             <?php if (isset($_SESSION['usuario_id'])): ?>
        <input type="text" id="searchInput" placeholder="Buscar en licenciado" onchange="searchTable2()" onkeyup="searchTable2()">
        <?php else: ?>
        <input type="text" id="searchInput" placeholder="Buscar en licenciado" onchange="searchTable3()" onkeyup="searchTable3()">
      <?php endif; ?>   
        <button id="startButton">Escanear</button>
                    </div>
            <video class="video" id="video" width="100%" height="100px"></video>

                <table id="tabla_fed">
                        <thead>
                            <tr>
                                <th class="<?php echo $columna == 'apellidos' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('apellidos')" >Apellidos</th>
                                <th class="<?php echo $columna == 'Nombre' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('Nombre')" >Nombre</th>
                                <th class="<?php echo $columna == 'uci' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('uci')" >UCI</th>
                                <th class="<?php echo $columna == 'licencia' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('licencia')" >Licencia N°</th>
                                <th class="<?php echo $columna == 'categoria' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('categoria')" >Categoría</th>
                                <th>Estado Licencia</th>
                            </tr>
                        <thead>
                        <tbody>
                            <?php foreach ($corredores as $corredor): ?>
                  <?php $formattedUCI = substr($corredor['uci'] ?? '', 0, 3) . ' ' . 
                                    substr($corredor['uci'] ?? '', 3, 3) . ' ' .
                                    substr($corredor['uci'] ?? '', 6, 3) . ' ' .
                                    substr($corredor['uci'] ?? '', 9, 2);
               
               
                                    if (substr($corredor['categoria'], 0, 11) === 'Auxiliar - ') {
    $corredor['categoria'] = substr($corredor['categoria'], 11); // Elimina 'Auxiliar - ' al inicio
}
                     
               
               
               
                ?>
                                <tr  style="background-color:<?php if($corredor['lic'] == 'Suspendida'):?>#f2d7d5<?php else:?>#a0cb9e94<?php endif; ?>" class="clickable-row">
                                    <td data-label="Apellido"><?php echo htmlspecialchars($corredor['apellidos']); ?></td>
                                    <td data-label="Nombre"><?php echo htmlspecialchars($corredor['Nombre']); ?></td>
                                    <td data-label="UCI"><?php echo htmlspecialchars($formattedUCI); ?></td>
                                    <td class="federacion hidden" data-label="Federación"><?php echo htmlspecialchars($corredor['federacion']); ?></td>
                                    <td class="apellidonombre hidden" data-label="apellidonombre"><?php echo htmlspecialchars($corredor['apellidos']); ?> <?php echo htmlspecialchars($corredor['Nombre']); ?></td>                  

                                    <td data-label="Licencia"><?php echo htmlspecialchars($corredor['licencia']); ?></td>
                                    <td data-label="UCI"><?php echo htmlspecialchars($corredor['categoria']); ?></td>
                                    <td data-label="Estado Lic"><?php echo htmlspecialchars($corredor['lic']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                  
        </div>
    </main>
</body>
<script>
const codeReader = new ZXing.BrowserMultiFormatReader();
const videoElement = document.getElementById('video');
const documentoInput = document.getElementById('searchInput');
const beepSound = new Audio('admin/config/beep.mp3');

document.getElementById('startButton').addEventListener('click', function () {
    document.querySelector('.video').style.display = 'block';
    codeReader.decodeFromVideoDevice(null, videoElement, (result, error) => {
        if (result) {
            const detectedText = result.getText();

            // Obtener la cuarta parte (��ndice 3)
            const rawText = detectedText.split(',')[3].trim();

            // Formatear el texto a 000 000 000 00
            const formattedText = rawText.replace(/(\d{3})(?=\d)/g, '$1 ').trim();

            // Establecer el valor en el input con id 'documento'
            documentoInput.value = formattedText;
                document.querySelector('.video').style.display = 'none';
        searchTable3();
        searchTable2();

        }
        if (error) {
            console.error(error);
        }
    });
});



        const checkbox = document.getElementById('disponibilidad');
        const tabla = document.getElementById('tabla_fed');
        var feduser = document.getElementById('feduser').value;
        const filas = tabla.querySelectorAll('tbody tr');

function filtrarTabla() {
        // Filtrar la tabla seg��n el estado del checkbox
const mostrarDisponibles = checkbox.checked;

            filas.forEach(row => {
                const disponibilidad = row.querySelector('.federacion').textContent;
                if (mostrarDisponibles) {
                    if (disponibilidad === feduser) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                } else {
                    row.style.display = '';
                }
            });
        }
        
        
// Ejecutar el filtro al cargar la página
        window.addEventListener('load', function () {
            filtrarTabla();
            searchTable2();
        });

        // Filtrar la tabla al cambiar el estado del checkbox
        checkbox.addEventListener('change', function() {
            filtrarTabla();
            searchTable2();

        });

</script>
</html>
