<?php

// filepath: /c:/xampp/htdocs/licencias/header.php
$current_page = basename($_SERVER['PHP_SELF']);
function obtenerTituloPagina() {
    // Tabla de referencias: Nombre del archivo PHP => Título
    $titulos = [
        'bienvenida.php' => 'Inicio',
        'formulario.php' => 'Formulario de inscripción',
        'index1.php' => 'Impresión Licencia',
        'home.php' => 'SIADE',
        '/products.php' => 'Nuestros Productos',
        '/services.php' => 'Servicios',
        // Añade más páginas según sea necesario
    ];

    // Obtenemos el nombre del archivo PHP actual
    $archivo_actual = basename($_SERVER['PHP_SELF']);

    // Verificamos si el archivo actual está en nuestra tabla de referencias
    if (array_key_exists($archivo_actual, $titulos)) {
        return $titulos[$archivo_actual];
    } else {
        // Si no se encuentra, extraemos el nombre del archivo sin la extensión
        $nombre_archivo = pathinfo($archivo_actual, PATHINFO_FILENAME);
        // Convertimos el nombre del archivo a un título más legible
        return ucwords(str_replace('_', ' ', $nombre_archivo));
    }
}


// Uso de la función
$titulo_pagina = obtenerTituloPagina();

function obtenerPaginaReferencia() {
    if (isset($_SERVER['HTTP_REFERER'])) {
        return $_SERVER['HTTP_REFERER'];
    } else {
        return 'Directo o Desconocido';
    }
}


// Uso de la función
$pagina_anterior = obtenerPaginaReferencia();
include($_SERVER['DOCUMENT_ROOT'].'/licencias/admin/config/db.php');
session_start(); // Start the session
// Obtener el nivel de acceso del usuario
if(isset($_SESSION['usuario_id'])) {

$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];
}
?>




<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=yes">
    <link rel="manifest" href="https://ciclismoarg.com/licencias/manifest.json">
<link rel="apple-touch-icon" sizes="180x180" href="/licencias/admin/icons/180logo.png">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="theme-color" content="#0056b3">
<meta name="application-name" content="Licencias Ciclismo Argentina">



<script>
if ('serviceWorker' in navigator) {
  navigator.serviceWorker.register('https://ciclismoarg.com/licencias/service-worker.js')
    .then((registration) => {
      console.log('Service Worker registrado con éxito:', registration);
    })
    .catch((error) => {
      console.log('Error al registrar el Service Worker:', error);
    });
}

</script>

  <script src="https://kit.fontawesome.com/ad1090de93.js" crossorigin="anonymous"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link rel="stylesheet" type="text/css" href="https://ciclismoarg.com/licencias/admin/styles.css?id=1435">
<link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
<style>

#user {
    border-right: none !important;
}

</style>

<header>
<div style="display: flex
;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 40px;
    flex-direction: column;margin-bottom:0" class="header-container">
<div class="logo-container1">
            <img style="margin-top:15" src="https://ciclismoarg.com/licencias/admin/config/logo2.jpeg" alt="Logo" height="50">

<?php if(isset($_SESSION['usuario_id'])): ?>
        <div style="" id="user" class="dropdown">
        <a style="border-radius: 50px;
    font-size: .75em;
    margin-right: 20px;" href="#" class="button main"><?php echo htmlspecialchars(strtoupper($_SESSION["usuario"])); ?> - <?php echo htmlspecialchars($federacion_usuario); ?> ▾ </a>
        <div class="dropdown-content">
                        <a href="cerrar_sesion.php" class="">Cerrar Sesión</a>
                        </div>
        </div>       
<?php endif; ?>
</div>
<div id="header1home" class="logo-container">
            <img src="https://ciclismoarg.com/licencias/admin/config/logo2.jpeg" alt="Logo" height="50">
            <?php if(isset($_SESSION['usuario_id'])): ?>
        <div style="" id="user" class="dropdown">
        <a style="border-radius: 50px;
    font-size: .75em;
    margin-right: 20px;" href="#" class="button main"><?php echo htmlspecialchars(strtoupper($_SESSION["usuario"])); ?> - <?php echo htmlspecialchars($federacion_usuario); ?> ▾ </a>
        <div class="dropdown-content">
                        <a href="https://ciclismoarg.com/licencias/admin/cerrar_sesion.php" class="">Cerrar Sesión</a>
                        </div>
        </div>       
<?php endif; ?>
    </div>
    <div id="obread">
 
    <div class="bread">

    <h1><?php echo htmlspecialchars(($titulo_pagina)); ?></h1>
 
    </div>
            <?php if (isset($_SESSION['usuario_id'])): ?>
    <div class="bread1">
        <?php if($current_page != 'home.php'): ?>
    <h1><a class="enlace-sin-formato" href="https://ciclismoarg.com/licencias/home.php"><i class="fa-solid fa-arrow-left" style="
    font-size: 1rem !important;!i;!;!o;!om;!o;!;
    font-weight: 600 !important;!i;!;!m;!;
">Volver</i></a></h1>
<?php endif; ?>
    </div>
    <?php endif; ?>
    
</div>

    </div>
                            

</header>