<?php
require('fpdf/code128.php');
date_default_timezone_set('America/Argentina/Buenos_Aires');
include_once('config/db1.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
class PDF extends FPDF
{
    
    // Page header
   function Header()
    {
        // Logo a la izquierda
        $this->Image('IMG_8490.PNG', 10, 6, 40);
        //$this->Image('https://ciclismoarg.com.ar/licencias/licencia (1).png', 90, 6, 40);
        // Título a la izquierda
        //$this->SetFont('Arial', 'B', 15);
        //$this->Cell(80);
        //$this->Cell(30, 10, 'Licencia', 0, 0, 'C');
         // Logo a la derecha
        $this->Image('logo2.jpeg', $this->w - 130, -4, 40); // Ajusta la posición y el tamaño según sea necesario


        // Logo a la derecha
        $this->Image('logo1.jpeg', $this->w - 30, 6, 20); // Ajusta la posición y el tamaño según sea necesario

        // Línea de separación
       // $this->Line(10, 40, $this->w - 10, 40);

        // Salto de línea
        $this->Ln(20);
    }
    // Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
    
    
}

$registro_id = isset($_POST['id']) ? $_POST['id'] : null;

if (!is_numeric($registro_id)) {
    die("ID de registro no válido.");
}

// Conexión a la base de datos usando PDO
$conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Preparar y ejecutar la consulta usando PDO
$stmt = $conn->prepare("SELECT * FROM users WHERE id = :id");
$stmt->bindParam(':id', $registro_id, PDO::PARAM_INT);
$stmt->execute();

// Recuperar el resultado
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (substr($row['categoria'], 0, 11) === 'Auxiliar - ') {
    $row['categoria'] = substr($row['categoria'], 11); // Elimina 'Auxiliar - ' al inicio
}

$uci = substr($row['uci'] ?? '', 0, 3) . ' ' . 
                                    substr($row['uci'] ?? '', 3, 3) . ' ' .
                                    substr($row['uci'] ?? '', 6, 3) . ' ' .
                                    substr($row['uci'] ?? '', 9, 2);

$pdf = new PDF_Code128();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 15);
        $pdf->Image('IMG_8490.PNG', 10, 6, 40);

        
        $pdf->Image('logo2.jpeg', 90, -4, 40); // Ajusta la posición y el tamaño según sea necesario


        // Logo a la derecha
        $pdf->Image('ucranuevo.png', 160, 10, 40); // Ajusta la posición y el tamaño según sea necesario

        // Salto de línea
        $pdf->Ln(20);


$texto = "¡Hola!";
$pdf->MultiCell(0, 7, utf8_decode($texto));
$pdf->Ln(); // Agregar espacio entre el texto y la tabla

$pdf->SetFont('Arial', '', 10);
$texto = "La licencia debe ser Impresa o mantenerse en formato digital.
Puede cortar la Licencia por el borde, doblar al medio y plastificar.
Recordar que se puede requerir el DNI conjuntamente con la licencia. Datos Seguro -
CONTACTO Sr. Martín Chames email chamesmart@gmail.com";
$pdf->MultiCell(0, 7, utf8_decode($texto));
$pdf->Ln(36); // Agregar espacio entre el texto y la tabla



// Mostrar imagen de fondo
$pdf->Image('licarg2025-1.png', 10, 106, 190, 0);

// Imprimir datos en el PDF
if ($row) {
    $doc = $row['documento'];
    $imagenUrl = 'fotos/' . $doc . '.png';

    // Manejo de imagen
    if (@getimagesize($imagenUrl)) {
        $pdf->Image($imagenUrl, 15, 119, 28, 35);
    } else {
        $pdf->Image('sinfoto.png', 15, 119, 30, 0);
    }

    $pdf->Cell(43, 10, '', 0);
    $pdf->SetFont('Arial', 'B', 20);
    $pdf->Cell(37, 10, $row['licenciaanio'], 0);
    $pdf->SetFont('Arial', '', 7);
     $pdf->Cell(18, 9, '', 0);

    $pdf->Ln();
    $pdf->Cell(98, -4, '', 0);

      $pdf->Ln(.5);
    $pdf->SetFont('Arial', 'B', 12);
     $pdf->Cell(37, 10, '', 0);
    $pdf->Cell(40, 10, utf8_decode($row['apellidos']), 0);
    $pdf->SetFont('Arial', '', 7);
    $pdf->Cell(21, 10, '', 0);
   // Guardar la posición actual antes de imprimir MultiCell
$posicionActual = $pdf->GetX();
$posicionVertical = $pdf->GetY();
$pdf->SetY($pdf->GetY() + 1.5);
// Cambiar Cell a MultiCell para 'federacion'
 $pdf->Cell(122, 10, '', 0);
$pdf->MultiCell(0, 3, utf8_decode($row['federacion']), 0, 'L');

// Restaurar la posición después de imprimir MultiCell
$pdf->SetXY($posicionActual, $posicionVertical);
    $pdf->Cell(24, 11, '', 0);
    $pdf->Cell(10, 11, utf8_decode($row['categoria']), 0);
    $pdf->Ln(); // Agregar nueva línea
    $pdf->Cell(37, -2, '', 0);
    $pdf->SetFont('Arial', '', 11);
    $pdf->Cell(40, -2, utf8_decode($row['Nombre']), 0);
     $pdf->SetFont('Arial', '', 7);
    $pdf->Cell(45, -5.3, '', 0);
             $pdf->Cell(7, -5.3, utf8_decode($row['club']), 0);
                 $posicionActual = $pdf->GetX();
$posicionVertical = $pdf->GetY();
$pdf->SetY($pdf->GetY() - 10);
$pdf->SetX($pdf->GetX()+122);
$pdf->Cell(10, 20, 'ARGENTINA', 0);
$posicionActual = $pdf->GetX();
$posicionVertical = $pdf->GetY();
$pdf->SetY($pdf->GetY() + 5);
$pdf->SetX($pdf->GetX()+122);
$pdf->SetFont('Arial', '', 6);
$textWidth = $pdf->GetStringWidth(utf8_decode($row['calle']));

$pdf->Cell($textWidth, 16, utf8_decode($row['calle']), 0);

$pdf->Cell(1, 16, '', 0);
$pdf->SetFont('Arial', '', 5);
$pdf->Cell(10, 16, utf8_decode($row['ciudad']), 0);
$pdf->SetFont('Arial', '', 7);
$posicionActual = $pdf->GetX();
$posicionVertical = $pdf->GetY();
$pdf->SetY($pdf->GetY() + 3);
$pdf->SetX($pdf->GetX()+122);
$pdf->Cell(10, 16, utf8_decode($row['opseguro']), 0);


$posicionVertical = $pdf->GetY();
$pdf->SetY($pdf->GetY() -14);

    $pdf->Ln(); // Agregar nueva línea

$posicionEspacio = strpos($row['categoria'], ' ');
$textWidth = $pdf->GetStringWidth(utf8_decode($row['categoria']));

if ($textWidth > 22) {
    $categoriacorta = strstr($row['categoria'], ' ', true);
    $categorialarga = $row['categoria'];
    $textnuevo =  $pdf->GetStringWidth(utf8_decode($categoriacorta));
    $separacionclub = 24 -  $textWidth;
} else {
    // Si no hay espacios, mostrar el texto completo
    $categoriacorta = $row['categoria'];
    $separacionclub = 24 - $textWidth;
}

$posicionEspacio1 = strpos($row['club'], ' ');
$textWidth1 = $pdf->GetStringWidth(utf8_decode($row['club']));
if ($textWidth1 > 15) {
    $clubcorto = strstr($row['club'], ' ', true);
} else {
    // Si no hay espacios, mostrar el texto completo
    $clubcorto = $row['club'];
}

$separacionemerg = 50 - $textWidth1;

    $pdf->Cell(37, 18, '', 0);
    $pdf->Cell(10, 18, utf8_decode($row['licencia']), 0);
    $pdf->Cell(12, 18, '', 0);
    $pdf->Cell($textWidth, 18,  utf8_decode($categoriacorta), 0);
    $pdf->Cell($separacionclub, 18, '', 0);
    $pdf->Cell($textWidth1, 18,  utf8_decode($clubcorto), 0);
    $pdf->Cell($separacionemerg, 18, '', 0);
    $pdf->Cell(20, 18, utf8_decode($row['emergencia']), 0);
        $posicionActual = $pdf->GetX();
$posicionVertical = $pdf->GetY();
$pdf->SetY($pdf->GetY() + 2);
$pdf->SetX($pdf->GetX()+132);
    $pdf->Cell(20, 18, 'Tel: ' . utf8_decode($row['telemergencia'] ), 0);
    $pdf->Ln(); // Agregar nueva línea
    $posicionActual = $pdf->GetX();
$posicionVertical = $pdf->GetY();
$pdf->SetY($pdf->GetY() - 5);
    $pdf->Cell(37, 5, '', 0);
    $pdf->Cell(10, 5, utf8_decode($row['fechanac']), 0);    
    $pdf->Cell(16, 5, '', 0);
    $pdf->Cell(10, 5, utf8_decode($row['genero']), 0);     
    $pdf->Cell(10, 5, '', 0);
    $pdf->Cell(10, 5, utf8_decode($row['nacionalidad']), 0);

    $pdf->Ln(); // Agregar nueva línea
    $pdf->Cell(37, 10, '', 0);
    $pdf->Cell(10, 10, date('d-m-Y'), 0);    
    $pdf->Cell(14, 10, '', 0);
    $pdf->Cell(10, 10, $row['documento'], 0);     
    $pdf->Cell(7, 10, '', 0);
   $pdf->Cell(10, 10, utf8_decode($row['rol']), 0);      
    
    
    $pdf->Ln(); // Agregar nueva línea
    $pdf->SetTextColor(255, 0, 0);
    $pdf->Cell(9, 5, '', 0);
    $pdf->SetFont('Arial', '', 12 ,'B');
    $pdf->Cell(20, 5, $uci, 0,0,'C');    

    $pdf->SetFont('Arial', '', 7);
        $pdf->Cell(8, 5, '', 0);
    $pdf->Cell(10, 5, $row['LicValida'], 0);    
        
    $pdf->Ln(70); // Agregar nueva línea

  // Construir la URL de la imagen
    $imagen1 = 'fotos/' . $row['uci'] . '.png';

 // Agregar la imagen desde la URL
    if (@getimagesize($imagen1)) {
    $pdf->Image($imagen1, 65, 155, 60, 30);
    } else {
        
    }
$archivonombre = $row['uci'] . ' - ' . $row['apellidos'] . ', ' . $row['Nombre'] . '.pdf' ;
    
}


$pdf->SetTextColor(255, 0, 0);
$pdf->SetFont('Arial', 'U', 10);
$texto = "Si encuentras algún error en tu licencia, debes notificarlo para su corrección.";
$pdf->MultiCell(0, 7, utf8_decode($texto));
$pdf->Ln(); // Agregar espacio entre el texto y la tabla

// Cerrar la conexión a la base de datos


// Salida del PDF
$pdf->Output('I' , $archivonombre);

?>
