
function mostrarFormulario() {
    document.getElementById('formularioRegistro').classList.remove('hidden');
    document.getElementById('registro0').classList.add('hidden');
}

function calcularEdad() {
    const fechaNac = document.getElementById('fechanac').value;
    const anioNacimiento = parseInt(fechaNac.slice(0, 4)); // Tomar el año de la fecha de nacimiento
    const licenciaAnio = parseInt(document.getElementById('licenciaanio').value);
    const edad = licenciaAnio - anioNacimiento;
    document.getElementById('edadanios').value = edad;
 
    // Llamada AJAX para obtener las categorías
 const genero = document.getElementById('genero').value;
    const xhr = new XMLHttpRequest();
    xhr.open('POST', 'obtener_categorias.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4 && xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            const categorias0 = response.categorias0;
            const categorias1 = response.categorias1;

            const categoria0Select = document.getElementById('categoria0');
            categoria0Select.innerHTML = '<option value="">Seleccione una categoría</option>';
            categorias0.forEach(function(categoria) {
                const option = document.createElement('option');
                option.value = categoria;
                option.textContent = categoria;
                categoria0Select.appendChild(option);
            });

            const categoria1Select = document.getElementById('categoria1');
            categoria1Select.innerHTML = '<option value="">Seleccione una subcategoría</option>';
            categorias1.forEach(function(categoria) {
                const option = document.createElement('option');
                option.value = categoria;
                option.textContent = categoria;
                categoria1Select.appendChild(option);
            });
        }
    };
    xhr.send('genero=' + encodeURIComponent(genero) + '&edadAnios=' + encodeURIComponent(edad));
}




document.addEventListener('DOMContentLoaded', function() {
    // Función para actualizar las opciones de categoria1
    function actualizarCategoria1() {
        // Obtén el valor de categoria0
        const catselected = document.getElementById('categoria0').value;
        

        // Obtener el valor de edad y género desde alguna fuente, por ejemplo, valores de formularios
        const edadAnios = parseInt(document.getElementById('edadanios').value); // Asegúrate de que el input de edad tenga id "edadanios"
        const genero = document.getElementById('genero').value; // O usa otro selector según cómo esté configurado el género

        let categorias1 = [];

        // Verificar si la primera palabra es "Comisario"
        if (catselected.split(' ')[0] === 'Comisario') {
            if (edadAnios > 19) {
                if (genero === 'M') {
                    categorias1 = ['Mecánico', 'Técnico', 'Dirigente', 'Guía', 'Delegado', 'Masajista', 'Prensa', 'Fotógrafo', 'Organizador'];
                } else {
                    categorias1 = ['Mecánica', 'Técnica', 'Dirigente', 'Guía', 'Delegada', 'Masajista', 'Prensa', 'Fotógrafa', 'Organizadora'];
                }
            }
        } else {
            if (edadAnios > 19) {
                if (genero === 'M') {
                    categorias1 =  ['Mecánico', 'Técnico', 'Dirigente', 'Guía', 'Delegado', 'Masajista', 'Prensa', 'Fotógrafo', 'Organizador', 'MC', 'MH', 'MT', 'MB'];
                } else {
                    categorias1 = ['Mecánico', 'Técnico', 'Dirigente', 'Guía', 'Delegado', 'Masajista', 'Prensa', 'Fotógrafo', 'Organizadora','WC', 'WH', 'WT', 'WB'];
                }
            }
        }

        // Ahora actualizamos las opciones del <select> de categoria1
        const categoria1Select = document.getElementById('categoria1');
        categoria1Select.innerHTML = ''; // Limpiar las opciones existentes

        // Agregar la opción por defecto
        const defaultOption = document.createElement('option');
        defaultOption.value = '';
        defaultOption.textContent = 'Seleccione una subcategoría';
        categoria1Select.appendChild(defaultOption);
        
        let catselected1 = '';  // Inicializamos catselected1 con un valor vacío

        const cate1actualElement = document.getElementById('cate1actual');
        if (cate1actualElement) {
            catselected1 = cate1actualElement.value; // Asignamos el valor si el elemento existe
        }
        

        // Verificar si categoriaGuardadaParte está en la lista de opciones
        if (categorias1.includes(catselected1)) {
            // Agregar las nuevas opciones basadas en categorias1
            categorias1.forEach(function(categoria) {
                const option = document.createElement('option');
                option.value = categoria;
                option.textContent = categoria;

                // Si la categoria guardada está en la lista, seleccionarla
                if (categoria === catselected1) {
                    option.selected = true;
                }

                categoria1Select.appendChild(option);
            });
        } else {
            // Si categoriaGuardadaParte no está en la lista, simplemente agregamos las opciones sin marcar ninguna como seleccionada
            categorias1.forEach(function(categoria) {
                const option = document.createElement('option');
                option.value = categoria;
                option.textContent = categoria;
                categoria1Select.appendChild(option);
            });
        }
    }

    // Actualizar las opciones cuando cargue la página
    actualizarCategoria1();

    // Agregar el evento de cambio para categoria0
    document.getElementById('categoria0').addEventListener('change', actualizarCategoria1);
});