<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso < 0 && $nivel_acceso != 3 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}
// Incluir la configuración de la base de datos
include('config/db.php');
include('config/ver_campeonato_data.php');
require('header.php');
// Obtener las categorías asociadas al campeonato
$id_campeonato = $carrera['id'];
$sql = "SELECT categoria FROM campeonato_cat WHERE id_campeonato = :id_campeonato";
$stmt = $conn->prepare($sql);
$stmt->bindParam(':id_campeonato', $id_campeonato, PDO::PARAM_INT);
$stmt->execute();
$categorias_asociadas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Crear una cadena con las categorías separadas por coma
$categorias_lista = array_map(function($categoria) {
    return $categoria['categoria'];
}, $categorias_asociadas);

$categorias_comas = implode(" | ", $categorias_lista);
?>

<!DOCTYPE html>
<html lang="es">
   
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=12434">
    <link rel="stylesheet" type="text/css" href="styles.css?id=12434">
    <script src="config/campeonato.js?id=450" defer></script>
    <title>Inscripciones a campeonatos</title>

    <style>
    .prueba-container {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
        border-bottom: solid 1px #ccc;
        border-top: solid 1px #ccc;

    }

    .prueba-label {
        margin-right: 10px;
        font-size: 14px;
        color: #333;
        text-align: left;
        flex-grow: 1; /* Hace que la etiqueta ocupe el espacio disponible */
    }

    .prueba-checkbox {
        width: 40px;
        height: 40px;
        scale: 1.3;
        cursor: pointer;
        accent-color: #2e86c1; /* Color moderno para el checkbox */
    }
         .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            max-width:100%;
           
        }

        .column-left {
            flex-basis: 30%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: inset 0 -3px 3px rgba(0, 0, 0, 0.1);

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        @media (max-width: 768px) {
    .column-container {
        flex-direction: column;
    }
    .inner {
        width: 100%;
        padding: 20px 0px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    td.label {
            font-weight: bold;
     
            width: 20%;
        }
}
        
    </style>
    
</head>

<body>

        <div class="column-container">
            <div class="column-left">
                <div class="inner buscar">
                    <h3>Detalles del evento</h3>
                    <?php if($carrera['activo'] == 1): ?>
                        <h2 style="background-color:green;color:white;padding:15px;margin:10px;border-radius:3rem">Inscripciones ABIERTAS</h2>
                    <?php else: ?>
                    <h2 style="background-color:red;color:white;padding:15px;margin:10px;border-radius:3rem">Inscripciones cerradas.</h2>
                    <?php endif; ?>
                            <table class="detalle">
                                <tr>
                                    <td class="label">Nombre del campeonato:</td>
                                    <td><?php echo htmlspecialchars($carrera['campeonato_nombre']); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Fecha:</td>
                                    <td><?php echo htmlspecialchars($carrera['campeonato_fecha']); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Lugar:</td>
                                    <td><?php echo htmlspecialchars($carrera['campeonato_lugar']); ?></td>
                                </tr>
                           
                            
                            <tr>
                            <td class="label">Categorías:</td>
                            </tr>
                                               </table>

                            <br>
                            <?php echo htmlspecialchars($categorias_comas); ?><br>
                </div>
                <?php if($carrera['activo'] == 1): ?>
                <div class="inner" style="margin-bottom: 25px">
                    <h3>Agregar Corredor</h3>       
                        <form id="searchForm" action="" method="post" style="position: relative; display: inline-block; margin-bottom: 20px;">
                            <input type="text" id="documento" name="documento" value="" onkeyup="showSuggestions1(this.value)" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
                            <input type="hidden" id="carrera_id" name="id" value="<?php echo $carrera['id']; ?>">
                            <input id="enviar" type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
                            <div id="suggestions" style="display: none;"></div>
                        </form>
                </div>         
                <?php endif; ?> 
                <div class="inner">
                    <h3>Descargar reporte</h3>       
                    <a class="export" href="exportar_empadronado_campeonato.php?id=<?php echo $carrera['id']; ?>" class="button">Exportar a Excel</a>             
                </div>    
                        
            </div>

    
        <div class="column-right" style="min-height: 200px;">
            <div class="inner">
                <?php if (isset($_SESSION['success_msg'])): ?>
                        <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
                    <?php unset($_SESSION['success_msg']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error_msg'])): ?>
                        <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
                <?php unset($_SESSION['error_msg']); ?>
                <?php endif; ?>
                <h3>Corredores Empadronados</h3>
                    <table id="tabla">
                        <thead>
                            <tr>
                                <th class="<?php echo $columna == 'documento' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('documento')" >DNI</th>
                                <th class="<?php echo $columna == 'Nombre' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('Nombre')" >Nombre</th>
                                <th class="<?php echo $columna == 'apellidos' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('apellidos')" >Apellidos</th>
                                <th class="<?php echo $columna == 'categoria' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('categoria')" >Categoría</th>
                                <th class="<?php echo $columna == 'nombre_prueba' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('nombre_prueba')" >Prueba</th>
                                <th class="<?php echo $columna == 'time' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('time')" >Registro</th>
                                <th></th>
                            </tr>
                        <thead>
                        <tbody>
                            <?php foreach ($corredores as $corredor): ?>
                                <tr>
                                    <td data-label="Documento" class="documento"><?php echo htmlspecialchars($corredor['documento']); ?></td>
                                    <td data-label="Nombre"><?php echo htmlspecialchars($corredor['Nombre']); ?></td>
                                    <td data-label="Apellido"><?php echo htmlspecialchars($corredor['apellidos']); ?></td>
                                    <td data-label="Categoría"><?php echo htmlspecialchars($corredor['categoria']); ?></td>
                                    <td data-label="Prueba"><?php echo htmlspecialchars($corredor['nombre_prueba']); ?></td>
                                    <td data-label="Registro"><?php echo htmlspecialchars($corredor['time']); ?></td>
                                    <?php if($carrera['activo'] == 1): ?>
                                    <td data-label="Eliminar" onclick="eliminarinscripcion()" style="color:red;font-weight:600">X</td>
                                    <?php endif; ?>

                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <div class="pagination">
                            <?php if ($pagina_actual > 1): ?>
                                <a href="ver_campeonato.php?id=<?php echo $carrera['id']; ?>&page=<?php echo $pagina_actual - 1; ?>">&laquo;</a>
                            <?php endif; ?>
                            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                                <a href="ver_campeonato.php?id=<?php echo $carrera['id']; ?>&page=<?php echo $i; ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                                    <?php echo $i; ?>
                                </a>
                            <?php endfor; ?>
                            <?php if ($pagina_actual < $total_paginas): ?>
                                <a href="ver_campeonato.php?id=<?php echo $carrera['id']; ?>&page=<?php echo $pagina_actual + 1; ?>">&raquo;</a>
                            <?php endif; ?>
                </div>
            </div>
        </div>
    </div>


    <div id="myModal8" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal8()">&times;</span>
            <h2>Resultados de la Búsqueda</h2>
            <div id="modal-body"></div>
        </div>
    </div>
    <div id="myModal9" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal9()">&times;</span>
            <h2>Eliminar Registro</h2>
            <div id="modal-body1"></div>
        </div>
    </div>
</body>
</body>
</html>