<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');
include('config/bienvenida_data.php');

// Obtener los usuarios actuales
$usuario_id = $_GET['usuario_id'];

$sql = "SELECT usuario_id, usuario, nivel_acceso, federacion_id FROM usuarios WHERE usuario_id = :usuario_id";
$stmt_usuarios = $conn->prepare($sql);
$stmt_usuarios->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt_usuarios->execute();
$usuario = $stmt_usuarios->fetch(PDO::FETCH_ASSOC);

// Obtener las federaciones
$sql_federaciones = "SELECT id, federacion FROM federaciones";
$stmt_federaciones = $conn->prepare($sql_federaciones);
$stmt_federaciones->execute();
$federaciones = $stmt_federaciones->fetchAll(PDO::FETCH_ASSOC);

// Obtener el ID del usuario a editar o verificar si es un nuevo registro
$usuario_id = $_GET['usuario_id'] ?? null;
$is_new_record = ($usuario_id === '*');

if (!$is_new_record && $usuario_id === null) {
    echo "ID de usuario no proporcionado.";
    exit();
}

// Inicializar variables
$usuario = [
    'usuario' => '',
    'nivel_acceso' => '',
    'federacion_id' => ''
];

if (!$is_new_record) {
    // Obtener los datos del usuario
    $sql = "SELECT usuario_id, usuario, nivel_acceso, federacion_id, email FROM usuarios WHERE usuario_id = :usuario_id";
    $stmt_usuarios = $conn->prepare($sql);
    $stmt_usuarios->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt_usuarios->execute();
    $usuario = $stmt_usuarios->fetch(PDO::FETCH_ASSOC);

    if (!$usuario) {
        echo "Usuario no encontrado.";
        exit();
    }
}

// Obtener las federaciones
$sql_federaciones = "SELECT id, federacion FROM federaciones";
$stmt_federaciones = $conn->prepare($sql_federaciones);
$stmt_federaciones->execute();
$federaciones = $stmt_federaciones->fetchAll(PDO::FETCH_ASSOC);

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario_nombre = $_POST['usuario'];
    $nivel_acceso = $_POST['nivel_acceso'];
    $federacion_id = $_POST['federacion_id'];
    $contrasena = $_POST['contrasena'];
    $email = $_POST['email'];

    if ($is_new_record) {
        // Insertar un nuevo registro
        $sql_insert = "INSERT INTO usuarios (usuario, nivel_acceso, federacion_id, contrasena, email) VALUES (:usuario, 0, :federacion_id, :contrasena, :email)";
        $stmt_insert = $conn->prepare($sql_insert);
        $stmt_insert->bindParam(':usuario', $usuario_nombre, PDO::PARAM_STR);
        $stmt_insert->bindParam(':email', $email, PDO::PARAM_STR);
        $stmt_insert->bindParam(':federacion_id', $federacion_id, PDO::PARAM_INT);
        if (!empty($contrasena)) {
            $hash_contrasena = password_hash($contrasena, PASSWORD_DEFAULT);
            $stmt_insert->bindParam(':contrasena', $hash_contrasena, PDO::PARAM_STR);
        } else {
            echo "La contraseña es obligatoria para un nuevo registro.";
            exit();
        }

        if ($stmt_insert->execute()) {
            $_SESSION['success_msg'] = "Usuario creado correctamente.";
            header('Location: usuarios.php');
            exit();
        } else {
            $_SESSION['error_msg'] = "Error al crear el usuario.";
        }
    } else {
        // Actualizar un registro existente
        $sql_update = "UPDATE usuarios SET usuario = :usuario, nivel_acceso = 0, federacion_id = :federacion_id, email = :email";
        if (!empty($contrasena)) {
            $hash_contrasena = password_hash($contrasena, PASSWORD_DEFAULT);
            $sql_update .= ", contrasena = :contrasena";
        }
        $sql_update .= " WHERE usuario_id = :usuario_id";

        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bindParam(':usuario', $usuario_nombre, PDO::PARAM_STR);
        $stmt_update->bindParam(':email', $email, PDO::PARAM_STR);
        $stmt_update->bindParam(':federacion_id', $federacion_id, PDO::PARAM_INT);
        if (!empty($contrasena)) {
            $stmt_update->bindParam(':contrasena', $hash_contrasena, PDO::PARAM_STR);
        }
        $stmt_update->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);

        if ($stmt_update->execute()) {
            $_SESSION['success_msg'] = "Usuario actualizado correctamente.";
            header('Location: usuarios.php');
            exit();
        } else {
            $_SESSION['error_msg'] = "Error al actualizar el usuario.";
        }
    }
}

// Obtener el nivel de acceso del usuario
$usuario_id1 = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id1, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2) { // Cambia este valor según el nivel de acceso requerido
    echo "No tienes permiso para acceder a esta página.";
    exit();
}

include('header.php');
$mensaje = '';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Cambiar Licencia Año</title>
    <link rel="stylesheet" type="text/css" href="styles.css?id=123">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=1423">

    <script src="config/scripts.js" defer></script>
</head>
<body>

        <main>
        <h2><?php echo $is_new_record ? 'Crear Usuario' : 'Editar Usuario'; ?></h2>
        <?php
        // Mostrar el mensaje de error si existe
        if (isset($_SESSION['error_msg'])) {
            echo "<div class='error' style='color: red;'>" . $_SESSION['error_msg'] . "</div>";
            unset($_SESSION['error_msg']);  // Limpiar el mensaje después de mostrarlo
        }
        ?>
        <form method="POST" action="">
            <div>
                <label for="usuario">Nombre:</label>
                <input type="text" id="usuario" name="usuario" value="<?php echo htmlspecialchars($usuario['usuario']); ?>" required>
            </div>
            <div>
                <label for="nivel_acceso">Nivel de Acceso:</label>
                <input type="number" id="nivel_acceso" name="nivel_acceso" value="<?php echo htmlspecialchars($usuario['nivel_acceso']); ?>" required>
            </div>
            <div>
                <label for="federacion_id">Federación:</label>
                <select id="federacion_id" name="federacion_id" required>
                    <?php foreach ($federaciones as $federacion): ?>
                        <option value="<?php echo htmlspecialchars($federacion['id']); ?>" <?php if ($federacion['id'] == $usuario['federacion_id']) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($federacion['federacion']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
                        <div>
                <label for="email">Email</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($usuario['email']); ?>" required>
            </div>
            <div>
                <label for="contrasena">Contraseña:</label>
                <input type="password" id="contrasena" name="contrasena" <?php echo $is_new_record ? 'required' : ''; ?>>
                <small><?php echo $is_new_record ? '' : 'Deja en blanco para no cambiar la contraseña'; ?></small>
            </div>
            <a id="cancelar" href="usuarios.php">Cancelar</a>
            <button type="submit">Guardar Cambios</button>

        </form>
    </main>
</body>
</html>