<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');
include('config/bienvenida_data.php');

// Obtener los usuarios actuales

$sql = "SELECT u.usuario_id, u.usuario, u.nivel_acceso, f.federacion 
        FROM usuarios u
        JOIN federaciones f ON u.federacion_id = f.id";
$stmt_usuarios = $conn->prepare($sql);
$stmt_usuarios->execute();
$usuarios = $stmt_usuarios->fetchAll(PDO::FETCH_ASSOC);


// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2) { // Cambia este valor según el nivel de acceso requerido
    echo "No tienes permiso para acceder a esta página.";
    exit();
}

include('header.php');
$mensaje = '';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Cambiar Licencia Año</title>
    <link rel="stylesheet" type="text/css" href="styles.css?id=12553">
    <script src="config/scripts.js" defer></script>
    <style>
         .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            max-width:100%;
           
        }
        
        .column-left {
            flex-basis: 60%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: inset 0 -3px 3px rgba(0, 0, 0, 0.1);

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
            border-radius: 3em;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        .filtrofecha{
    display:flex;
    flex-direction:row;
    gap:30px;
    justify-content:center
}
.accion {
    display: flex;
    flex-direction: row;
    justify-content: space-between;
    align-items: center;
    width: max-content;
    gap: 5px;
}
        @media (max-width: 768px) {
            .column-container {
        flex-direction: column;
    }
    .inner {
   
        padding: 15px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    td.label {
            font-weight: bold;
     
            width: 20%;
        }
        .filtrofecha{
            display: flex
;
        flex-direction: column;
        gap: 5px;
        justify-content: space-around;
        /* width: 50%; */
        align-items: center;
}
.accion {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    align-items: stretch;
    width: max-content;
    text-align: center;
    gap: 5px;
}
}

        
    </style>
</head>
<body>

    <main class="contenedor">
        <h3>Alta y Modificación Usuarios</h3>
        <div class="export">
        <a class="export" href="usuarios_edit.php?usuario_id=*" class="button">Nuevo Usuario</a>
        </div>
        <table>
            <thead>
                <tr>
                    <th>Usuario</th>
                    <th>Federación</th>
                    <th>Nivel de Acceso</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($usuarios as $usuario): ?>
                    <tr class="clickable-row">
                        <td data-label="Usuario"><?php echo htmlspecialchars($usuario['usuario']); ?></td>
                        <td data-label="Federación"><?php echo htmlspecialchars($usuario['federacion']); ?></td>
                        <td data-label="Acceso"><?php echo htmlspecialchars($usuario['nivel_acceso']); ?></td>
                        <td class="accion">
                            <a class="button accion" href="usuarios_edit.php?usuario_id=<?php echo $usuario['usuario_id']; ?>">Editar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </main>
</body>
</html>