<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}
include_once('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso < 2) { // Cambia este valor según el nivel de acceso requerido
    echo "No tienes permiso para acceder a esta página.";
    exit();
}

include('config/uci_data.php');
require('header.php');
date_default_timezone_set('America/Argentina/Buenos_Aires');

$server_timestamp = date('Y-m-d\TH:i');

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>
    <link rel="stylesheet" type="text/css" href="stylespagos.css?id=14234">
    <link rel="stylesheet" type="text/css" href="styles.css?id=1232434">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=122434">



           <script src="config/scripts.js?id=32434" defer></script>
           <script src="config/uci.js?id=32434" defer></script>
</head>
<body>


    <main>
        <h2 id="titulo">Licencias Pendientes de UCI</h2>

        <form id="searchForm" action="" method="get" style="position: relative; display: inline-block; margin-bottom: 20px;">
            <input type="text" id="documento" name="documento" value="<?php echo htmlspecialchars($documento); ?>" onkeyup="showSuggestions(this.value)" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
            <input type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            <div id="suggestions" style="display: none;"></div>
        </form>

        <table id="tabla">
            <thead>
            <tr>
                <th>Nombre</th>
                <th>Apellido</th>
                <th>Documento</th>
                <th>UCI</th>
                <th>Estado licencia</th>
                <th>Fecha de Pago</th>
                <th>Acción</th>
            </tr>
</thead>
<tbody>
            <?php if (empty($registros)): ?>
                <tr>
                    <td colspan="6">El corredor no se encuentra listo para registrar el pago.</td>
                </tr>
            <?php endif; ?>
                <tr>
                </tr>
            <?php foreach ($registros as $fila): ?>
                    <tr>
                    <td class="Nombre"><?php echo htmlspecialchars($fila["Nombre"]); ?></td>
                    <td class="apellidos"><?php echo htmlspecialchars($fila["apellidos"]); ?></td>
                    <td class="documento"><?php echo htmlspecialchars($fila["documento"]); ?></td>
                    <td><?php echo htmlspecialchars($fila["uci"] ?? '' ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($fila["lic"]); ?></td>
                    <td><?php echo $fila['fecha_pago'] ? date('d/m/Y', strtotime($fila['fecha_pago'])) : 'NO PAGADA'; ?></td>
                    <td><a id="datos" href="#" class="button" style="background-color: grey" onclick="mostrardatos()">Ver Datos</a><a id="uci" href="#" class="button" onclick="cargaruci()">Cargar UCI</a></td>
                    <td class="genero" style="display:none"><?php echo htmlspecialchars($fila["genero"]); ?></td>
                    <td class="fechanac" style="display:none"><?php echo htmlspecialchars($fila["fechanac"]); ?></td>
                    <td class="nacionalidad" style="display:none"><?php echo htmlspecialchars($fila["nacionalidad"]); ?></td>
                    <td class="federacion" style="display:none"><?php echo htmlspecialchars($fila["federacion"]); ?></td>
                    <td class="categoria" style="display:none"><?php echo htmlspecialchars($fila["categoria"]); ?></td>
                    <td class="licencia" style="display:none"><?php echo htmlspecialchars($fila["licencia"]); ?></td>

                    
                    </tr>
                    <?php endforeach; ?>
            </tbody>
        </table>

        <div class="pagination">
            <?php if ($pagina_actual > 1): ?>
                <a href="uci.php?page=<?php echo $pagina_actual - 1; ?>&documento=<?php echo htmlspecialchars($documento); ?>">&laquo;</a>
            <?php endif; ?>
            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                <a href="uci.php?page=<?php echo $i; ?>&documento=<?php echo htmlspecialchars($documento); ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="uci.php?page=<?php echo $pagina_actual + 1; ?>&documento=<?php echo htmlspecialchars($documento); ?>">&raquo;</a>
            <?php endif; ?>
        </div>
    </main>

    <div id="myModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal1()">&times;</span>
            <h2 style="margin-bottom:20px">Registrar UCI</h2>
            <form id="pagoForm" action="config/registrar_uci.php" method="POST">
                <input type="text" id="documentouci" name="documentouci" value="" readonly>
                <div>
                    <label for="uci">Código UCI:</label>
                    <input type="text" id="uci" name="uci" pattern="^\d{11}$" placeholder="Sólo ingresar 11 números" required>
                </div>
                <button type="submit" class="button summit">Registrar</button>
            </form>
        </div>
    </div>

    <div id="myModal9" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal9()">&times;</span>
            <h2>Datos Corredor</h2>
            <div id="modal-body1"></div>
        </div>
    </div>

</body>
</html>
