<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso != 2 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}
// Incluir la configuración de la base de datos
include('config/db.php');
include('config/suspendidos_data.php');
require('header.php');

$hoy = strtotime(date('Y-m-d'));

?>

<!DOCTYPE html>
<html lang="es">
   
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=12434">
    <link rel="stylesheet" type="text/css" href="styles.css?id=12434">
    <script src="config/scripts.js?id=1323323" defer></script>
    <script src="config/suspension.js?id=323223" defer></script>
    <title>Suspendidos</title>
    <style>
         .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            max-width:100%;
           
        }
        
        .column-left {
            flex-basis: 30%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: inset 0 -3px 3px rgba(0, 0, 0, 0.1);

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        @media (max-width: 768px) {
            .column-container {
        flex-direction: column;
    }
    .inner {
   
        padding: 15px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    td.label {
            font-weight: bold;
     
            width: 20%;
        }
        .filtrofecha{
            display: flex
;
        flex-direction: column;
        gap: 5px;
        justify-content: space-around;
        /* width: 50%; */
        align-items: center;
}
.accion {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    align-items: stretch;
    width: max-content;
    text-align: center;
    gap: 5px;
}
}
        
    </style>
    
</head>

<body>

        <div class="column-container">
            <div class="column-left">

                <div class="inner buscar">
                    <h3>Suspender Corredor</h3>       
                        <form id="searchForm" action="" method="post" style="position: relative; display: inline-block; margin-bottom: 20px;">
                            <input type="text" id="documento" name="documento" value="" onkeyup="showSuggestions1(this.value)" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
                            <input type="hidden" id="carrera_id" name="id" value="<?php echo $carrera['id']; ?>">
                            <input id="enviar" type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
                            <div id="suggestions" style="display: none;"></div>
                        </form>
                </div>         
                <div class="inner">
                    <h3>Descargar reporte</h3>      
                    <div class="export"> 
                    <a class="export" href="exportar_suspensiones.php" class="button">Exportar a Excel</a>             
                </div>    
                </div>    
    
            </div>

    
        <div class="column-right" style="min-height: 200px;">
            <div class="inner">
                <?php if (isset($_SESSION['success_msg'])): ?>
                        <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
                    <?php unset($_SESSION['success_msg']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error_msg'])): ?>
                        <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
                <?php unset($_SESSION['error_msg']); ?>
                <?php endif; ?>
                <h3>Corredores Suspendidos</h3>
                <input type="checkbox" id="filterSuspendido" onclick="filterTable()"> Mostrar anteriores
                    <table id="tabla">
                        <thead>
                            <tr>
                                <th class="<?php echo $columna == 'documento' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('documento')" >DNI</th>
                                <th class="<?php echo $columna == 'Nombre' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('Nombre')" >Nombre</th>
                                <th class="<?php echo $columna == 'apellidos' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('apellidos')" >Apellidos</th>
                                <th class="<?php echo $columna == 'federacion' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('federacion')" >Federación</th>
                                <th class="<?php echo $columna == 'categoria' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('categoria')" >Categoría</th>
                                <th class="<?php echo $columna == 'suspendido' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('suspendido')" >Estado</th>
                                <th class="<?php echo $columna == 'acta' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('acta')" >Acta</th>
                                <th class="<?php echo $columna == 'fecha_desde' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('fecha_desde')" >Fecha Desde</th>
                                <th class="<?php echo $columna == 'fecha_hasta' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('fecha_hasta')" >Fecha Hasta</th>
                                <th class="" ></th>

                            </tr>
                        <thead>
                        <tbody>
                            <?php foreach ($corredores as $corredor): ?>
                                <?php 
                                    $estado_suspension = ($hoy >= strtotime($corredor['fecha_desde']) && $hoy <= strtotime($corredor['fecha_hasta'])) ? 'Suspendido' : 'Terminada';
                                 ?>
                                <tr style="<?php if ($estado_suspension == "Suspendido"):?>background-color:#f2d7d5<?php else:?>display:none;<?php endif;?>" >
                                    <td data-label="Documento" class="documento"><?php echo htmlspecialchars($corredor['documento']); ?></td>
                                    <td data-label="ID" class="id" style="display:none"><?php echo htmlspecialchars($corredor['id']); ?></td>
                                    <td data-label="Nombre"><?php echo htmlspecialchars($corredor['Nombre']); ?></td>
                                    <td data-label="Apellidos"><?php echo htmlspecialchars($corredor['apellidos']); ?></td>
                                    <td data-label="Federación"><?php echo htmlspecialchars($corredor['federacion']); ?></td>
                                    <td data-label="Categoría"><?php echo htmlspecialchars($corredor['categoria']); ?></td>
                                    <td data-label="Estado de Suspensión"><?php echo $estado_suspension; ?></td>
                                    <td data-label="Acta"><?php echo htmlspecialchars($corredor['acta']); ?></td>
                                    <td data-label="Fecha Desde"><?php echo htmlspecialchars($corredor['fecha_desde']); ?></td>
                                    <td data-label="Fecha Hasta"><?php echo htmlspecialchars($corredor['fecha_hasta']); ?></td>
                                    <td onclick="eliminarsuspension()" style="<?php if ($estado_suspension == "Suspendido"):?>color:red;font-weight:600<?php else:?>display:none;<?php endif;?>">X</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <div class="pagination">
                            <?php if ($pagina_actual > 1): ?>
                                <a href="suspendidos.php?page=<?php echo $pagina_actual - 1; ?>">&laquo;</a>
                            <?php endif; ?>
                            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                                <a href="suspendidos.php?page=<?php echo $i; ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                                    <?php echo $i; ?>
                                </a>
                            <?php endfor; ?>
                            <?php if ($pagina_actual < $total_paginas): ?>
                                <a href="suspendidos.php?page=<?php echo $pagina_actual + 1; ?>">&raquo;</a>
                            <?php endif; ?>
                </div>
            </div>
        </div>
    </div>


    <div id="myModal8" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal8()">&times;</span>
            <h2>Resultados de la Búsqueda</h2>
            <div id="modal-body"></div>
        </div>
    </div>
    <div id="myModal9" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal9()">&times;</span>
            <h2>Levantar Suspensión</h2>
            <div id="modal-body1"></div>
        </div>
    </div>
</body>
</html>