<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.html");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

include('config/seguro_data.php');
include('header.php');

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reportes seguro</title>
    <script src="config/scripts.js" defer></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>

    <link rel="stylesheet" type="text/css" href="styles.css?id=12345">
    <style>
         .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            max-width:100%;
           
        }
        
        .column-left {
            flex-basis: 60%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: inset 0 -3px 3px rgba(0, 0, 0, 0.1);

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
            border-radius: 3em;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        .filtrofecha{
    display:flex;
    flex-direction:row;
    gap:30px;
    justify-content:center
}
.accion {
    display: flex;
    flex-direction: row;
    justify-content: space-between;
    align-items: center;
    width: max-content;
    gap: 5px;
}
        @media (max-width: 768px) {
            .column-container {
        flex-direction: column;
    }
    .inner {
   
        padding: 15px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    td.label {
            font-weight: bold;
     
            width: 20%;
        }
        .filtrofecha{
            display: flex
;
        flex-direction: column;
        gap: 5px;
        justify-content: space-around;
        /* width: 50%; */
        align-items: center;
}
.accion {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    align-items: stretch;
    width: max-content;
    text-align: center;
    gap: 5px;
}
}

        
    </style>
</head>
<body>

    <main class="contenedor">
        <h2 id="titulo" >Reportes Seguro</h2>
        <div class="export">
        <a class="export" href="exportar_seguro.php?date=*" class="button">Exportar todos los enviados</a>
        </div>
        <table id="federadosTable">
            <thead>
            <tr>
                <th>Fecha de envío</th>
                <th>Descargar</th>
            </tr>
</thead>
<tbody>
            <?php foreach ($seguros as $seguro): ?>
                <tr class="clickable-row">
                <td data-label="Fecha Envío"><?php echo htmlspecialchars($seguro['fecha_seguro'] ?? 'Pendientes de Envío'); ?> ( <?php echo htmlspecialchars($seguro['cantidad'] ?? 'sin envío'); ?> )</td>
<?php if (!$seguro['fecha_seguro']): ?>
                <td><a href="exportar_seguro.php?date=<?php echo htmlspecialchars($seguro['fecha_seguro'] ?? 'sinenvio'); ?>" class="button">Descargar y registrar</a></td>
<?php else: ?>
    <td><a href="exportar_seguro.php?date=<?php echo htmlspecialchars($seguro['fecha_seguro'] ?? 'sinenvio'); ?>" class="button">Descargar</a></td><?php endif; ?>
                </tr>
            <?php endforeach; ?>
</tbody>
        </table>

        <div class="pagination">
            <?php if ($pagina_actual > 1): ?>
                <a href="seguro.php?page=<?php echo $pagina_actual - 1; ?>">&laquo;</a>
            <?php endif; ?>
            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                <a href="seguro.php?page=<?php echo $i; ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="seguro.php?page=<?php echo $pagina_actual + 1; ?>">&raquo;</a>
            <?php endif; ?>
        </div>
    </main>
    <script>
        function exportTableToExcel(tableID, filename = ''){
            var downloadLink;
            var dataType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
            var tableSelect = document.getElementById(tableID);
            var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
            
            // Create a Blob from the table HTML
            var blob = new Blob([tableHTML], { type: dataType });

            // Create a link element
            downloadLink = document.createElement("a");

            // Set the link's href to a URL created from the Blob
            downloadLink.href = URL.createObjectURL(blob);

            // Set the download attribute with a filename
            downloadLink.download = filename ? filename + '.xls' : 'excel_data.xls';

            // Append the link to the body
            document.body.appendChild(downloadLink);

            // Click the link to trigger the download
            downloadLink.click();

            // Remove the link from the document
            document.body.removeChild(downloadLink);
        }
    </script>
</body>
</html>
