<?php
session_start();


if (isset($_POST['g-recaptcha-response'])) {
    $recaptcha_secret = '6LeCEbMqAAAAAJGbMuhDdIeSoy6zGndk-IRviMJR';
    $recaptcha_response = $_POST['g-recaptcha-response'];

    // Verificar la respuesta con Google
    $url = 'https://www.google.com/recaptcha/api/siteverify';
    $data = [
        'secret' => $recaptcha_secret,
        'response' => $recaptcha_response
    ];

    $options = [
        'http' => [
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    $context  = stream_context_create($options);
    $response = file_get_contents($url, false, $context);
    $response_keys = json_decode($response, true);

    // Validar el score de reCAPTCHA
    $score = $response_keys['score'];
    if ($score < 0.5) {
        $_SESSION['error_msg'] = 'Verificación de reCAPTCHA fallida. Intenta nuevamente.';
        header('Location: ' . $_SERVER['HTTP_REFERER']);
        exit;
    }
} else {
    $_SESSION['error_msg'] = 'No se ha recibido la verificación de reCAPTCHA.';
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;
}


// Mostrar errores para depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuración de la conexión a la base de datos
include_once('config/db.php');

// Procesar el formulario al enviar
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtener y limpiar datos del formulario
    $usuario = limpiarEntrada($_POST["usuario"]);
    $contrasena = limpiarEntrada($_POST["contrasena"]);

    try {
        // Preparar consulta para buscar al usuario
        $sql = "SELECT * FROM usuarios WHERE usuario = :usuario";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':usuario', $usuario, PDO::PARAM_STR);
        $stmt->execute();

        // Verificar si el usuario existe
        if ($stmt->rowCount() > 0) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Verificar la contraseña
            if (password_verify($contrasena, $user['contrasena'])) {
                // Inicio de sesión exitoso
                $_SESSION["usuario"] = $usuario;
                $_SESSION["usuario_id"] = $user['usuario_id'];
                $_SESSION["usuario_fedid"] = $user['federacion_id'];
                $_SESSION["email"] = $user['email'];
                if ($user['nivel_acceso'] == 3) {
                    header("Location: pagos.php");
                } else {
                header("Location: ../home.php");
                }
                exit();
            } else {
                // Contraseña incorrecta, mostrar mensaje de error
                $_SESSION['error_msg'] = "Usuario o contraseña incorrectos.";
            }
        } else {
            // Usuario no encontrado, mostrar mensaje de error
            $_SESSION['error_msg'] = "Usuario o contraseña incorrectos.";
        }
    } catch (PDOException $e) {
        // Error en la consulta, mostrar mensaje de error
        $_SESSION['error_msg'] = "Error al ejecutar la consulta: " . $e->getMessage();
    }

    // Redirigir a login.php en caso de error
    header('Location: login.php');
    exit();
}

// Función para sanitizar entradas
function limpiarEntrada($dato) {
    return htmlspecialchars(trim($dato), ENT_QUOTES, 'UTF-8');
}
?>
