<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}
include_once('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2) { // Cambia este valor según el nivel de acceso requerido
    echo "No tienes permiso para acceder a esta página.";
    exit();
}

include('config/pagos_master_data.php');
require('header.php');
date_default_timezone_set('America/Argentina/Buenos_Aires');

$server_timestamp = date('Y-m-d\TH:i');

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>
    <link rel="stylesheet" type="text/css" href="stylespagos.css?id=14234">
    <link rel="stylesheet" type="text/css" href="styles.css?id=1232434">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=122434">



           <script src="config/scripts.js?id=322414" defer></script>
           <style>
           .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            max-width:100%;
           
        }
        
        .column-left {
            flex-basis: 60%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: inset 0 -3px 3px rgba(0, 0, 0, 0.1);

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
            border-radius: 3em;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        .filtrofecha{
    display:flex;
    flex-direction:row;
    gap:30px;
    justify-content:center
}
.accion {
    display: flex;
    flex-direction: row;
    justify-content: space-between;
    align-items: center;
    width: max-content;
    gap: 5px;
}
        @media (max-width: 768px) {
            .column-container {
        flex-direction: column;
    }
    .inner {
   
        padding: 15px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    td.label {
            font-weight: bold;
     
            width: 20%;
        }
        .filtrofecha{
            display: flex
;
        flex-direction: column;
        gap: 5px;
        justify-content: space-around;
        /* width: 50%; */
        align-items: center;
}
.accion {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    align-items: stretch;
    width: max-content;
    text-align: center;
    gap: 5px;
}
}
</style>
</head>
<body>


    <main style="max-width: 500px">
        <h2 id="titulo">Registro de pagos Masivos</h2>
        <?php if (isset($_SESSION['success_msg'])): ?>
            <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
            <?php unset($_SESSION['success_msg']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['error_msg'])): ?>
            <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
            <?php unset($_SESSION['error_msg']); ?>
        <?php endif; ?>
           <form id="pagoForm" action="config/registrar_pago_masterdata.php" method="POST">
            <div>
                                                <label for="federacion">Federación</label>
                                                <select id="federacionseleccionada" name="federacion">
                                                <?php foreach ($federaciones as $federacion): ?>
                                                    <option id="federacionseleccionada" value="<?= $federacion['federacion'] ?>" <?= isset($datos['federacion']) && $datos['federacion'] == $federacion['federacion'] ? 'selected' : '' ?> required>
                                                        <?= htmlspecialchars($federacion['federacion']) ?>
                                                    </option>
                                                <?php endforeach; ?>
                                                    </select>
                                                  
                                    </div>
                                    <div>
                    <label for="fecha_pago">Fecha de Pago:</label>
                    <input type="datetime-local" id="fecha_pago" name="fecha_pago" value="<?php echo $server_timestamp; ?>" required>
                    <a href="#" class="button" onclick="openModal3()">Registrar pago</a>
                </div>
            </form>
        </div>
                                            
        <h2 id="titulo">Pagos Masivos Realizados</h2>

        <table>
            <thead>
            <tr>
                <th>Federación</th>
                <th>Fecha</th>
                <th>Acción</th>
            </tr>
                                                </thead>
                                                <tbody>
            <?php if (empty($registros)): ?>
                <tr>
                    <td colspan="6">No hay pagos masivos.</td>
                </tr>
            <?php endif; ?>
            <?php foreach ($registros as $fila): ?>
                    <tr class="clickable-row">
                    <td data-label="Federación"><?php echo htmlspecialchars($fila["federacion"]); ?></td>
                    <td data-label="Fecha pago"><?php echo htmlspecialchars($fila["fecha_pago_mas"]); ?></td>
                    <td><a href="#" class="button eliminar" onclick="openModal4()">Eliminar pago</a></td>
                </tr>                    
                <?php endforeach; ?>
            </tbody>
        </table>
 

    <div id="myModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal1()">&times;</span>
            <h2 style="margin-bottom:20px">Registrar Pago</h2>
            <form id="pagoForm" action="config/registrar_pago_masterdata.php" method="POST">
                <div>
                    <label for="federacion">Federación:</label>
                    <input type="text" id="federacion" name="federacion" readonly>
                </div>
                <div>
                    <label for="fecha_pago">Fecha de Pago:</label>
                    <input type="datetime-local" id="fecha_pago" name="fecha_pago" value="<?php echo $server_timestamp; ?>" readonly>
                </div>

                <button type="submit" class="button summit">Registrar</button>
            </form>
        </div>
    </div>
    <div id="myModal2" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal4()">&times;</span>
            <h2 style="margin-bottom:20px">Eliminar pago Masivo</h2>
            <form id="pagoForm" action="config/eliminar_pago_masterdata.php" method="POST">
                <div>
                    <label for="federacion">Federación:</label>
                    <input type="text" id="federacion" name="federacion" value="<?php echo htmlspecialchars($fila["federacion"]); ?>" readonly>
                </div>
                <div>
                    <label for="fecha_pago_mas">Fecha de Pago:</label>
                    <input type="datetime-local" id="fecha_pago_mas" name="fecha_pago_mas" value="<?php echo htmlspecialchars($fila["fecha_pago_mas"]); ?>" readonly>
                </div>

                <button type="submit" class="button eliminar">Eliminar</button>
            </form>
        </div>
    </div>

    </main>
</body>
</html>
