<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}
include_once('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso < 2) { // Cambia este valor según el nivel de acceso requerido
    echo "No tienes permiso para acceder a esta página.";
    exit();
}
include('config/pagos_data.php');
include('config/pagos_data_all.php');

require('header.php');
date_default_timezone_set('America/Argentina/Buenos_Aires');

$server_timestamp = date('Y-m-d\TH:i');
$hoy = date('Y-m-d');
$hoy1 = date('Y-m-d', strtotime('-7 days'));

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>
    <link rel="stylesheet" type="text/css" href="stylespagos.css?id=14234">
 
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=122434">

    <link rel="stylesheet" type="text/css" href="styles.css?id=1232434">

           <script src="config/scripts.js?id=32234" defer></script>
           <style>
         .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            max-width:100%;
           
        }
        
        .column-left {
            flex-basis: 60%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: inset 0 -3px 3px rgba(0, 0, 0, 0.1);

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
            border-radius: 3em;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        .filtrofecha{
    display:flex;
    flex-direction:row;
    gap:30px;
    justify-content:center
}
.accion {
    display: flex;
    flex-direction: row;
    justify-content: space-between;
    align-items: center;
    width: max-content;
    gap: 5px;
}
        @media (max-width: 768px) {
            .column-container {
        flex-direction: column;
    }
    .inner {
   
        padding: 15px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    td.label {
            font-weight: bold;
     
            width: 20%;
        }
        .filtrofecha{
            display: flex
;
        flex-direction: column;
        gap: 5px;
        justify-content: space-around;
        /* width: 50%; */
        align-items: center;
}
.accion {
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    align-items: stretch;
    width: max-content;
    text-align: center;
    gap: 5px;
}
}

        
    </style>
    
</head>
<body>



    <div class="column-container">
            <div class="column-left">
                <div class="inner buscar">
        <h2 id="titulo">Registro de pagos</h2>

        <form id="searchForm" action="" method="get" style="position: relative; display: inline-block; margin-bottom: 20px;">
            <input type="text" id="documento" name="documento" value="<?php echo htmlspecialchars($documento); ?>" onkeyup="showSuggestions(this.value)" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
            <input type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            <div id="suggestions" style="display: none;"></div>
        </form>
        <table id="">
            <thead>
            <tr>
                <th>Nombre</th>
                <th>Apellido</th>
                <th>Documento</th>
                <th>UCI</th>
                <th>Estado licencia</th>
                <th>Fecha de Pago</th>
                <th style="text-align: center;">Acción</th>
            </tr>
</thead>
<tbody>
            <?php if (empty($_GET['documento'])): ?>
                
            <?php elseif (empty($registros)): ?>
                <tr>
                    <td colspan="6">El corredor no se encuentra listo para registrar el pago.</td>
                </tr>
            <?php endif; ?>
            <?php foreach ($registros as $fila): ?>
                    <tr class="clickable-row">
                    <td data-label="Nombre"><?php echo htmlspecialchars($fila["Nombre"]); ?></td>
                    <td data-label="Apellido"><?php echo htmlspecialchars($fila["apellidos"]); ?></td>
                    <td data-label="Documento"><?php echo htmlspecialchars($fila["documento"]); ?></td>
                    <td data-label="UCI"><?php echo htmlspecialchars($fila["uci"] ?? ''); ?></td>
                    <td data-label="Estado Lic."><?php echo htmlspecialchars($fila["lic"]); ?></td>
                    <td data-label="Fecha pago"><?php echo $fila['fecha_pago'] ? date('d/m/Y', strtotime($fila['fecha_pago'])) : 'NO PAGADA'; ?></td>
                    <?php if (is_null($fila['fecha_pago'])): ?>
                    <td><div class="accion">
                    <a href="#" class="button" onclick="openModal4()">Datos</a>
                    <a href="#" class="button" onclick="openModal1('<?php echo htmlspecialchars($fila['documento']); ?>', '<?php echo htmlspecialchars($fila['uci'] ?? ''); ?>')">Registrar pago</a></td> 
                    </div>
                    </tr>
                    
                    <?php elseif($fila['fecha_pago']): ?>
                    <td><a href="#" class="button eliminar" onclick="openModal2('<?php echo htmlspecialchars($fila['documento']); ?>', '<?php echo htmlspecialchars($fila['uci'] ?? ''); ?>')">Eliminar Pago</a></td>                </tr>
                    <?php endif; ?>
                    
                    <?php endforeach; ?>
                    </tbody>
        </table>



            </div>
    </div>
                <div class="column-right" style="min-height: 200px;">
                    <div class="inner">
                    <?php if (isset($_SESSION['success_msg'])): ?>
                        <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
                    <?php unset($_SESSION['success_msg']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error_msg'])): ?>
                        <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
                <?php unset($_SESSION['error_msg']); ?>
                <?php endif; ?>
                <h3>Pagos por Fecha</h3>
<div class="filtrofecha" style="">
    <div>
        Desde: <input type="date" id="searchInput1" value="<?php echo htmlspecialchars($hoy1); ?>" placeholder="Buscar en la tabla..." onchange="updateExportLink()">
    </div>
    <div>
        Hasta: <input type="date" id="searchInput2" value="<?php echo htmlspecialchars($hoy); ?>" placeholder="Buscar en la tabla..." onchange="updateExportLink()">
    </div>
    <div>
        Otra: <input type="text" id="searchInput3" placeholder="Buscar en la tabla..." onkeyup="searchTable1()">
    </div>
    <div style="text-align:center" class="export">
        <a id="exportLink" class="export" style="display: block;margin-top: 20px;" href="exportar_pagos.php" class="button">Exportar a Excel</a>
    </div>

                </div>
                    <table id="tabla">
                        <thead>
                            <tr>
                                <th class="" >Nombre</th>
                                <th class="" >Apellidos</th>
                                <th class="" >DNI</th>
                                <th class="" >UCI</th>
                                <th class="" >Estado Licencia</th>
                                <th class="" >Fecha Pago</th>
                            </tr>
                        <thead>
                        <tbody>
                            <?php foreach ($registros1 as $fila1): ?>
                                <tr>
                                <td data-label="Nombre"><?php echo htmlspecialchars($fila1["Nombre"]); ?></td>
                                <td data-label="Apellido"><?php echo htmlspecialchars($fila1["apellidos"]); ?></td>
                                <td data-label="Documento"><?php echo htmlspecialchars($fila1["documento"]); ?></td>
                                <td data-label="UCI"><?php echo htmlspecialchars($fila1["uci"] ?? ''); ?></td>
                                <td data-label="Estado Lic."><?php echo htmlspecialchars($fila1["lic"]); ?></td>
                                  <td data-label="Fecha pago"><?php echo $fila1['fecha_pago'] ? date('d/m/Y', strtotime($fila1['fecha_pago'])) : 'NO PAGADA'; ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    </div>
                      </div>
            </div>


    <div id="myModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal1()">&times;</span>
            <h2 style="margin-bottom:20px">Registrar Pago</h2>
            <form id="pagoForm" action="config/registrar_pago.php" method="POST">
                <input type="hidden" id="documento" name="documento" value="<?php echo htmlspecialchars($fila["documento"]); ?>">
                <div>
                    <label for="fecha_pago">Fecha de Pago:</label>
                    <input type="datetime-local" id="fecha_pago" name="fecha_pago" value="<?php echo $server_timestamp; ?>" required>
                </div>
                <div>
                    <label for="uci">Código UCI:</label>
                    <input type="text" id="uci" name="uci" required>
                </div>
                <button type="submit" class="button summit">Registrar</button>
            </form>
        </div>
    </div>

    <div id="myModal2" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2 style="margin-bottom:20px">Eliminar Pago</h2>
            <form id="pagoForm" action="config/eliminar_pago.php" method="POST">
                <input type="hidden" id="documento" name="documento" value="<?php echo htmlspecialchars($fila["documento"]); ?>">
                <div>

                </div>
                <button type="submit" class="button" id="cancelar">Eliminar pago</button>
            </form>
        </div>
    </div>
    <div id="myModal4" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal4()">&times;</span>
            <h2 style="margin-bottom:20px">Datos Corredor</h2>

            <div>
            <p> <b>Nombre: </b><?php echo htmlspecialchars($fila["Nombre"]); ?> <?php echo htmlspecialchars($fila["apellidos"]); ?></p>
            <p> <b>Fecha Nacimiento: </b><?php echo htmlspecialchars($fila["fechanac"]); ?></p>
            <p> <b>Género: </b><?php echo htmlspecialchars($fila["genero"]); ?></p>
            <p> <b>Nacionalidad: </b><?php echo htmlspecialchars($fila["nacionalidad"]); ?></p>
            <p> <b>Género: </b><?php echo htmlspecialchars($fila["genero"]); ?></p>
            <p> <b>Federación y Categoría: </b><?php echo htmlspecialchars($fila["federacion"]); ?> - <?php echo htmlspecialchars($fila["categoria"]); ?></p>
            <p> <b>Nro Licencia: </b><?php echo htmlspecialchars($fila["licencia"]); ?></p>
            <p> <b>Email: </b><?php echo htmlspecialchars($fila["email"]); ?></p>
            <p> <b>Tel: </b><?php echo htmlspecialchars($fila["telefono"]); ?></p>

                </div>
        </div>
    </div>
    


</body>
<script>
    function updateExportLink() {
        var desde = document.getElementById('searchInput1').value;
        var hasta = document.getElementById('searchInput2').value;
        var exportLink = document.getElementById('exportLink');
        
        // Actualizar el enlace con los valores desde y hasta
        exportLink.href = "exportar_pagos.php?desde=" + encodeURIComponent(desde) + "&hasta=" + encodeURIComponent(hasta);
    }
    
    // Inicializar el enlace con los valores al cargar la página
    window.onload = updateExportLink;
</script>
</html>
