<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}
include_once('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso < 0 || $nivel_acceso == 3) { // Cambia este valor según el nivel de acceso requerido
    echo "No tienes permiso para acceder a esta página.";
    exit();
}

include('config/federar_data.php');
require('header.php');
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>

    <link rel="stylesheet" type="text/css" href="styles.css?id=1234">
           <script src="config/scripts.js" defer></script>
           <style>
tr, th {
    text-align: left;
}
@media (max-width: 768px) {
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
        margin-bottom: 5px;
    }
    .editar {
        margin-top: 20px;
    }
    
    }
</style>
</head>
<body>


    <main>
        <h2 id="titulo">Federar corredores registrados</h2>

        <form id="searchForm" action="" method="get" style="position: relative; display: inline-block; margin-bottom: 20px;">
            <input type="text" id="documento" name="documento" value="<?php echo htmlspecialchars($documento); ?>" onkeyup="showSuggestions2(this.value)" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
            <input type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            <div id="suggestions" style="display: none;"></div>
        </form>

        <table>
            <thead>
            <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Apellido</th>
                <th>Documento</th>
                <th>Estado licencia</th>
                <th>Acción</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!isset($_GET['documento'])): ?>
                <tr>
                </tr>
            <?php elseif (empty($registros)): ?>
                <tr>
                    <td colspan="6">El corredor no se registró o ya está federado.</td>
                </tr>
            <?php endif; ?>
            <?php foreach ($registros as $fila): ?>
                <tr class="clickable-row">
                <td data-label="ID"><?php echo htmlspecialchars($fila["id"]); ?></td>
                <td data-label="Nombre"><?php echo htmlspecialchars($fila["Nombre"]); ?></td>
                <td data-label="Apellidos"><?php echo htmlspecialchars($fila["apellidos"]); ?></td>
                <td data-label="Documento"><?php echo htmlspecialchars($fila["documento"]); ?></td>
                <td data-label="Licencia"><?php echo htmlspecialchars($fila["lic"]); ?></td>
                <td class="editar"><a href="federar_registro.php?documento=<?php echo htmlspecialchars($fila["documento"]); ?>" class="button">Federar</a></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>

        <div class="pagination">
            <?php if ($pagina_actual > 1): ?>
                <a href="bienvenida.php?page=<?php echo $pagina_actual - 1; ?>&documento=<?php echo htmlspecialchars($documento); ?>">&laquo;</a>
            <?php endif; ?>
            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                <a href="bienvenida.php?page=<?php echo $i; ?>&documento=<?php echo htmlspecialchars($documento); ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="bienvenida.php?page=<?php echo $pagina_actual + 1; ?>&documento=<?php echo htmlspecialchars($documento); ?>">&raquo;</a>
            <?php endif; ?>
        </div>
    </main>
</body>
</html>
