<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso < 0) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

include('config/federados_data.php');
include('header.php');

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>
    <script src="config/scripts.js" defer></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>

    <link rel="stylesheet" type="text/css" href="styles.css?id=1435">

<style>
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 2px;
        font-size: .8rem;

    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        
    }

    th, td {
       
        
        border: 1px solid #000;
    }

tr:hover {
    background-color: #ccc;
}

.botontabla {
    text-align: center;
}
/* Ignorar el primer tr en el hover */


    th {
        padding-top: 5px;
        border: 2px solid;
        text-align: left;
    }
</style>









</head>
<body>

    <main>
   
        <div style="margin-bottom:10px" class="export">
        <a class="export" href="exportar_federados.php" class="button">Exportar a Excel</a>
        </div>
        <div style="text-align:center">
        <table id="federadosTable">
            <thead>
            <tr>
                <th>Apellido</th>
                <th>Nombre</th>
                <th>Documento</th>
                <th>Op. Seguro</th>
                <th>UCI</th>
                <th>Licencia</th>
                <th>Federación</th>
                <th>Categoría</th>
                <th>Estado licencia</th>
            </tr>
            <thead>
                <tbody>
            <?php foreach ($registros as $fila): ?>
                <tr class="clickable-row">
            <td data-label="Apellido"><?php echo htmlspecialchars($fila["apellidos"]); ?></td>
            <td data-label="Nombre"><?php echo htmlspecialchars($fila["Nombre"]); ?></td>
            <td data-label="Documento" class="extra"><?php echo htmlspecialchars($fila["documento"]); ?></td>
            <td data-label="Op. Seguro" class="extra"><?php echo htmlspecialchars($fila["opseguro"]); ?></td>
            <td data-label="UCI" class="extra"><?php echo htmlspecialchars($fila["uci"] ?? ''); ?></td>
            <td data-label="Licencia" class="extra"><?php echo htmlspecialchars($fila["licencia"]); ?></td>
            <td data-label="Federación" class="extra"><?php echo htmlspecialchars($fila["federacion"]); ?></td>
            <td data-label="Categoría" class="extra"><?php echo htmlspecialchars($fila["categoria"]); ?></td>
            <td data-label="Estado licencia" class="extra"><?php echo htmlspecialchars($fila["lic"]); ?></td>
            <?php endforeach; ?>
</tbody>
        </table>
            </div>

    </main>
    <script>
        function exportTableToExcel(tableID, filename = ''){
            var downloadLink;
            var dataType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
            var tableSelect = document.getElementById(tableID);
            var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
            
            // Create a Blob from the table HTML
            var blob = new Blob([tableHTML], { type: dataType });

            // Create a link element
            downloadLink = document.createElement("a");

            // Set the link's href to a URL created from the Blob
            downloadLink.href = URL.createObjectURL(blob);

            // Set the download attribute with a filename
            downloadLink.download = filename ? filename + '.xls' : 'excel_data.xls';

            // Append the link to the body
            document.body.appendChild(downloadLink);

            // Click the link to trigger the download
            downloadLink.click();

            // Remove the link from the document
            document.body.removeChild(downloadLink);
        }
    </script>
</body>
</html>
