<?php
// filepath: /c:/xampp/htdocs/licencias/admin/exportar_federados.php
session_start();

// Conexión a la base de datos usando PDO
include_once('config/db.php');



if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}
// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

if ($nivel_acceso !== 2 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}


// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];

$federacion_id_usuario = $_SESSION["usuario_fedid"];
// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];


// Consulta para obtener los corredores empadronados en la carrera
$sql_corredores = "SELECT u.documento, u.Nombre, u.lic, u.apellidos, u.categoria, u.suspendido, u.federacion, s.acta, s.id, s.fecha_desde, s.fecha_hasta 
                   FROM users u 
                   JOIN suspensiones s ON u.documento = s.documento
                   order by fecha_desde desc";



$stmt_corredores = $conn->prepare($sql_corredores);
$stmt_corredores->execute();
$registros = $stmt_corredores->fetchAll(PDO::FETCH_ASSOC);



// Incluir la biblioteca SimpleXLSXGen
require 'vendor/autoload.php';

use Shuchkin\SimpleXLSXGen;

// Preparar los datos para el archivo Excel
$data = [
    ['Apellido', 'Nombre', 'Documento', 'Federación', 'Categoría', 'Fecha Desde', 'Fecha Hasta', 'Acta', 'Estado Acutal']
];

foreach ($registros as $fila) {
    $data[] = [
        $fila['apellidos'],
        $fila['Nombre'],
        $fila['documento'],
        $fila['federacion'],
        $fila['categoria'],
        $fila['fecha_desde'],
        $fila['fecha_hasta'],
        $fila['acta'],
        $fila['lic']

    ];
}

// Crear el archivo Excel y enviarlo al navegador
$xlsx = SimpleXLSXGen::fromArray($data);
$xlsx->downloadAs('Suspendidos.xlsx');
exit;
?>