<?php
// filepath: /c:/xampp/htdocs/licencias/admin/exportar_federados.php
session_start();

// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener los datos de la consulta
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];

$fecha = $_GET['date'] ?? '';

// Construcción de la consulta
$sql = "SELECT * FROM users WHERE federado = 1 and fecha_pago is not null";
$params = [];

if ($fecha === 'sinenvio') {
    $sql .= " AND fecha_seguro IS NULL";
} elseif ($fecha === '*') {
    $sql .= " AND fecha_seguro IS not NULL";
} else {
    $sql .= " AND fecha_seguro = :fecha_seguro";
    $params[':fecha_seguro'] = "$fecha";
}

// Aplicar filtro de federación solo si federacion_id_usuario no es 1

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);

if ($fecha === 'sinenvio') {
    $fecha_nueva = date("Y-m-d H:i:s");
} else {
    $fecha_nueva = $fecha;
}

// Incluir la biblioteca SimpleXLSXGen
require 'vendor/autoload.php';

use Shuchkin\SimpleXLSXGen;

// Preparar los datos para el archivo Excel
$data = [
    ['Apellido', 'Nombre', 'Documento', 'Nacionalidad', 'Fecha Nac', 'Género', 'Op. Seguro', 'UCI', 'Licencia', 'Federación', 'Categoría', 'Estado licencia', 'Teléfono', 'Email', 'Fecha de envío seguro']
];

if ($fecha === '*') {
    foreach ($registros as $fila) {
        $data[] = [
            $fila['apellidos'],
            $fila['Nombre'],
            $fila['documento'],
            $fila['nacionalidad'],
            $fila['fechanac'],
            $fila['genero'],
            $fila['opseguro'],
            $fila['uci'],
            $fila['licencia'],
            $fila['federacion'],
            $fila['categoria'],
            $fila['lic'],
            $fila['telefono'],
            $sila['email'],
            $fila['fecha_seguro']
        ];
}
} else {
foreach ($registros as $fila) {
    $data[] = [
        $fila['apellidos'],
        $fila['Nombre'],
        $fila['documento'],
        $fila['nacionalidad'],
        $fila['fechanac'],
        $fila['genero'],
        $fila['opseguro'],
        $fila['uci'],
        $fila['licencia'],
        $fila['federacion'],
        $fila['categoria'],
        $fila['lic'],
        $fila['telefono'],
        $fila['email'],
        $fecha_nueva
    ];
}
}
// Crear el archivo Excel y enviarlo al navegador
$xlsx = SimpleXLSXGen::fromArray($data);
$filename = 'Envío al seguro - Federados - ' . $fecha_nueva . '.xlsx';
$xlsx->downloadAs($filename);

if ($fecha === 'sinenvio') {
$sql = "UPDATE users SET fecha_seguro = :fecha_seguro WHERE federado = 1 and fecha_seguro is null and fecha_pago is not null";

$stmt = $conn->prepare($sql);

// Ejecutar la consulta con los datos
$stmt->execute([
    ':fecha_seguro' => $fecha_nueva
]);
} else {

}
header('Location: seguros.php');



exit;










?>