<?php
// filepath: /c:/xampp/htdocs/licencias/admin/exportar_federados.php
session_start();

// Conexión a la base de datos usando PDO
include_once('config/db.php');

$desde = $_GET['desde'] ?? '';
$hasta = $_GET['hasta'] ?? '';

// Iniciar la consulta SQL base
$sql = "SELECT * 
        FROM users 
        WHERE federado = 1 
        AND fecha_pago IS NOT NULL";

// Agregar las condiciones de fechas si se proporcionan
if (!empty($desde) && !empty($hasta)) {
    $sql .= " AND fecha_pago BETWEEN :desde AND :hasta";  // Filtro por rango de fechas
} elseif (!empty($desde)) {
    $sql .= " AND fecha_pago >= :desde";  // Filtro solo por 'desde'
} elseif (!empty($hasta)) {
    $sql .= " AND fecha_pago <= :hasta";  // Filtro solo por 'hasta'
}

// Ejecutar la consulta con paginación
$stmt = $conn->prepare($sql);

// Vincular los parámetros si es necesario
if (!empty($desde)) {
    $stmt->bindParam(':desde', $desde);
}

if (!empty($hasta)) {
    $stmt->bindParam(':hasta', $hasta);
}

$stmt->execute();
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Incluir la biblioteca SimpleXLSXGen
require 'vendor/autoload.php';

use Shuchkin\SimpleXLSXGen;

// Preparar los datos para el archivo Excel
$data = [
    ['Apellido', 'Nombre', 'Documento', 'Op. Seguro', 'UCI', 'Licencia', 'Federación', 'Categoría', 'Estado licencia', 'Fecha Pago']
];

foreach ($registros as $fila) {
    $data[] = [
        $fila['apellidos'],
        $fila['Nombre'],
        $fila['documento'],
        $fila['opseguro'],
        $fila['uci'],
        $fila['licencia'],
        $fila['federacion'],
        $fila['categoria'],
        $fila['lic'],
        $fila['fecha_pago'],
    ];
}

// Crear el archivo Excel y enviarlo al navegador
$xlsx = SimpleXLSXGen::fromArray($data);
$xlsx->downloadAs('Pagos Registrados.xlsx');
exit;
?>