<?php
// filepath: /c:/xampp/htdocs/licencias/admin/exportar_federados.php
session_start();

// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener los datos de la consulta
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];

// Construcción de la consulta
$sql = "SELECT * FROM users WHERE federado = 1";
$params = [];

// Aplicar filtro de federación solo si federacion_id_usuario no es 1
if ($federacion_id_usuario != 1) {
    $sql .= " AND federacion = :federacion_usuario";
    $params[':federacion_usuario'] = $federacion_usuario;
}

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Incluir la biblioteca SimpleXLSXGen
require 'vendor/autoload.php';

use Shuchkin\SimpleXLSXGen;

// Preparar los datos para el archivo Excel
$data = [
    ['Apellido', 'Nombre', 'Documento', 'Op. Seguro', 'UCI', 'Licencia', 'Federación', 'Categoría', 'Estado licencia']
];

foreach ($registros as $fila) {
    $data[] = [
        $fila['apellidos'],
        $fila['Nombre'],
        $fila['documento'],
        $fila['opseguro'],
        $fila['uci'],
        $fila['licencia'],
        $fila['federacion'],
        $fila['categoria'],
        $fila['lic']
    ];
}

// Crear el archivo Excel y enviarlo al navegador
$xlsx = SimpleXLSXGen::fromArray($data);
$xlsx->downloadAs('Federados.xlsx');
exit;
?>