0<?php
// filepath: /c:/xampp/htdocs/licencias/admin/exportar_federados.php
session_start();

// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener los datos de la consulta
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];

// Obtener el ID de la carrera desde la URL
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['error_msg'] = "ID de carrera no válido.";
    header('Location: carreras.php');
    exit();
}

$carrera_id = (int)$_GET['id'];

// Consulta para obtener el nombre de la federación
$sql_carrera = "SELECT * FROM campeonatos WHERE id = :carrera_id";
$params = [':carrera_id' => $carrera_id];


$stmt_carrera = $conn->prepare($sql_carrera);



$sql_corredores = "SELECT u.documento, u.Nombre, u.apellidos, u.uci, u.lic, u.licencia, u.opseguro, u.categoria, u.fechanac, u.federacion, cr.id_prueba, cr.campeonato_id, cr.time, p.nombre_prueba, ca.campeonato_nombre, ca.campeonato_fecha, ca.campeonato_lugar FROM users u JOIN campeonatos_registros cr ON u.documento = cr.corredor_documento JOIN pruebas_campeonatos p ON cr.id_prueba = p.id JOIN campeonatos ca on cr.campeonato_id = ca.id WHERE u.lic = 'Activa' ";
// Ejecutar consulta con paginación
$params = [];

if ($federacion_id_usuario != 1) {
    $sql_corredores .= " AND cr.campeonato_id = :carrera_id AND u.federacion = :federacion";
    $params[':federacion'] = $federacion_usuario;
    $params[':carrera_id'] = $carrera_id;
} else {
    $sql_corredores .= " AND cr.campeonato_id = :carrera_id";
    $params[':carrera_id'] = $carrera_id;
}
    
    
$stmt_corredores = $conn->prepare($sql_corredores);
$stmt_corredores->execute($params);

$registros = $stmt_corredores->fetchAll(PDO::FETCH_ASSOC);




// Incluir la biblioteca SimpleXLSXGen
require 'vendor/autoload.php';

use Shuchkin\SimpleXLSXGen;

// Preparar los datos para el archivo Excel
$data = [
    ['Apellido', 'Nombre', 'Documento','Fecha Nacimiento', 'Op. Seguro', 'UCI', 'Licencia', 'Federación', 'Categoría', 'Estado licencia', 'Hora Empradronamiento', 'Campeonato', 'Prueba', 'Fecha Campeonato', 'Lugar Campeonato']
];

foreach ($registros as $fila) {
    $data[] = [
        $fila['apellidos'],
        $fila['Nombre'],
        $fila['documento'],
        $fila['fechanac'],
        $fila['opseguro'],
        $fila['uci'],
        $fila['licencia'],
        $fila['federacion'],
        $fila['categoria'],
        $fila['lic'],
        $fila['time'],
        $fila['campeonato_nombre'],
        $fila['nombre_prueba'],
        $fila['campeonato_fecha'],
        $fila['campeonato_lugar']
    ];
}

// Crear el archivo Excel y enviarlo al navegador
$xlsx = SimpleXLSXGen::fromArray($data);
$xlsx->downloadAs('Empadronados - Campeonato.xlsx');
exit;
?>