<?php
// filepath: /c:/xampp/htdocs/licencias/admin/exportar_federados.php
session_start();

// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener los datos de la consulta
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];

// Obtener el ID de la carrera desde la URL
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['error_msg'] = "ID de carrera no válido.";
    header('Location: carreras.php');
    exit();
}

$carrera_id = (int)$_GET['id'];

// Consulta para obtener el nombre de la federación
$sql_carrera = "SELECT * FROM carreras WHERE id = :carrera_id";
$params = [':carrera_id' => $carrera_id];

// Aplicar filtro de federación solo si federacion_id_usuario no es 1
if ($federacion_id_usuario <> 1) {
    $sql_carrera .= " AND federacion_id = :federacion_usuario";
    $params[':federacion_usuario'] = $federacion_id_usuario;
}

$stmt_carrera = $conn->prepare($sql_carrera);
if ($federacion_id_usuario <> 1) {
    $stmt_carrera->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
    $stmt_carrera->execute($params);
} else {
    $stmt_carrera = $conn->prepare("SELECT * FROM carreras WHERE id = :carrera_id");
    $stmt_carrera->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
    $stmt_carrera->execute();
}
$carrera = $stmt_carrera->fetch(PDO::FETCH_ASSOC);

if (!$carrera) {
    $_SESSION['error_msg'] = "Carrera no encontrada o no tienes permiso para editarla.";
    header('Location: carreras.php');
    exit();
}

$sql_corredores = "SELECT u.opseguro, u.uci, u.federacion, u.licencia, u.lic, u.documento, u.Nombre, u.apellidos, u.categoria, cr.time, c.nombre_carrera, c.federacion_carrera, c.fecha_carrera, c.lugar_carrera FROM users u JOIN carreras_registros cr ON u.documento = cr.corredor_documento join carreras c on c.id = cr.carrera_id WHERE cr.carrera_id = :carrera_id and u.lic = 'Activa' ";


$stmt_corredores = $conn->prepare($sql_corredores);
$stmt_corredores->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
$stmt_corredores->execute();
$registros = $stmt_corredores->fetchAll(PDO::FETCH_ASSOC);



// Incluir la biblioteca SimpleXLSXGen
require 'vendor/autoload.php';

use Shuchkin\SimpleXLSXGen;

// Preparar los datos para el archivo Excel
$data = [
    ['Apellido', 'Nombre', 'Documento', 'Op. Seguro', 'UCI', 'Licencia', 'Federación', 'Categoría', 'Estado licencia', 'Hora Empradronamiento', 'Carrera', 'Federación organizadora', 'Fecha Carrera', 'Lugar Carrera']
];

foreach ($registros as $fila) {
    $data[] = [
        $fila['apellidos'],
        $fila['Nombre'],
        $fila['documento'],
        $fila['opseguro'],
        $fila['uci'],
        $fila['licencia'],
        $fila['federacion'],
        $fila['categoria'],
        $fila['lic'],
        $fila['time'],
        $fila['nombre_carrera'],
        $fila['federacion_carrera'],
        $fila['fecha_carrera'],
        $fila['lugar_carrera']
    ];
}

// Crear el archivo Excel y enviarlo al navegador
$xlsx = SimpleXLSXGen::fromArray($data);
$xlsx->downloadAs('Empadronados.xlsx');
exit;
?>