<?php
// filepath: /c:/xampp/htdocs/licencias/admin/editar_usuario.php
session_start();

// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener el ID del usuario a editar
$id = $_GET['id'];

// Obtener los datos del usuario
$sql = "SELECT u.usuario_id, u.usuario, u.nivel_acceso, f.federacion 
        FROM usuarios u
        JOIN federaciones f ON u.federacion_id = f.id";
$stmt_usuarios = $conn->prepare($sql);
$stmt_usuarios->execute();
$usuarios = $stmt_usuarios->fetchAll(PDO::FETCH_ASSOC);

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $nivel_acceso = $_POST['nivel_acceso'];
    $contrasena = $_POST['contrasena'];

    // Generar el hash de la contraseña utilizando bcrypt
    $hash_contrasena = password_hash($contrasena, PASSWORD_DEFAULT);

    // Actualizar los datos del usuario en la base de datos
    $sql_update = "UPDATE users SET nombre = :nombre, nivel_acceso = :nivel_acceso, contrasena = :contrasena WHERE id = :id";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bindParam(':nombre', $nombre, PDO::PARAM_STR);
    $stmt_update->bindParam(':nivel_acceso', $nivel_acceso, PDO::PARAM_INT);
    $stmt_update->bindParam(':contrasena', $hash_contrasena, PDO::PARAM_STR);
    $stmt_update->bindParam(':id', $id, PDO::PARAM_INT);

    if ($stmt_update->execute()) {
        $_SESSION['success_msg'] = "Usuario actualizado correctamente.";
        header('Location: usuarios.php');
        exit;
    } else {
        $_SESSION['error_msg'] = "Error al actualizar el usuario.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Usuario</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
</head>
<body>
    <main>
        <h2>Editar Usuario</h2>
        <?php
        // Mostrar el mensaje de error si existe
        if (isset($_SESSION['error_msg'])) {
            echo "<div class='error' style='color: red;'>" . $_SESSION['error_msg'] . "</div>";
            unset($_SESSION['error_msg']);  // Limpiar el mensaje después de mostrarlo
        }
        ?>
        <form method="POST" action="">
            <div>
                <label for="nombre">Nombre:</label>
                <input type="text" id="nombre" name="nombre" value="<?php echo htmlspecialchars($usuario['nombre']); ?>" required>
            </div>
            <div>
                <label for="nivel_acceso">Nivel de Acceso:</label>
                <input type="number" id="nivel_acceso" name="nivel_acceso" value="<?php echo htmlspecialchars($usuario['nivel_acceso']); ?>" required>
            </div>
            <div>
                <label for="contrasena">Contraseña:</label>
                <input type="password" id="contrasena" name="contrasena" required>
            </div>
            <input type="submit" value="Guardar">
        </form>
    </main>
</body>
</html>