<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2) { // Cambia este valor según el nivel de acceso requerido
    header("Location: bienvenida.php");
    exit();
}
// Incluir la configuración de la base de datos
include('config/db.php');
include('config/editar_regmaster_data.php');
require('header.php');

?>

<!DOCTYPE html>
<html lang="es">
   
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" type="text/css" href="styles.css?id=134324">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=134324">

    <script src="config/scripts.js" defer></script>
    <title>Formulario de Inscripción</title>
    <style>
    /* Popup */
.popup {
display: <?= $show_popup ? 'block' : 'none' ?>;
position: fixed;
top: 50%;
left: 50%;
transform: translate(-50%, -50%);
background-color: #fff;
padding: 20px;
border-radius: 8px;
box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
max-width: 80%;  /* Ajuste para que el tamaño máximo sea el 80% de la pantalla */
width: 80%;      /* Ajuste para que el popup ocupe el 80% de la pantalla */
max-height: 80vh;  /* Ajuste para que el popup no supere el 80% de la altura de la pantalla */
height: 80vh;      /* Ajuste para que el popup ocupe el 80% de la altura de la pantalla */
overflow-y: auto;  /* Permite el desplazamiento vertical si el contenido es demasiado grande */
z-index: 200;
}
main {
        max-width: 90%;
        margin: 40px auto;
        background-color: transparent;
        padding: 20px;
        border-radius: 8px;
        box-shadow:none;
  
    }

</style>
</head>

<body>
<main class="contenedor">
    <div class="form-container">
        <div class="container">
            <h1>Editar Corredor</h1>
<hr>

       <?php if (isset($_GET['documento']) && $datos): 
                $fechaNacimiento = new DateTime(substr($datos['fechanac'], -4) . '-01-01');
                $anioLicencia = new DateTime($anios['licenciaanio'] . '-01-01');
                $edadAnios = $anioLicencia->diff($fechaNacimiento)->y;
                
                $stmt_categorias = $conn->prepare("
                    SELECT categoria 
                    FROM categorias0 
                    WHERE genero = :genero 
                    AND :edadAnios BETWEEN anios_desde AND anios_hasta
                ");

                $stmt_categorias->bindParam(':genero', $datos['genero'], PDO::PARAM_STR);
                $stmt_categorias->bindParam(':edadAnios', $edadAnios, PDO::PARAM_INT);
                $stmt_categorias->execute();
                $categorias0 = $stmt_categorias->fetchAll(PDO::FETCH_COLUMN);
                
                
                $categoriaactual1 = htmlspecialchars(explode(' - ', $datos['categoria'])[1] ?? '');
                
  
                $foto_path = '../fotos/' . $datos['documento'] . '.png';
    
                // Verificar si la foto existe
                $foto_existe = file_exists($foto_path);

                $foto_path1 = $foto_path . '?' .rand(1, 1000);



                ?>

            <!-- Mostrar formulario de edición si el documento existe en la base de datos -->

                            <form method="POST" action="" enctype="multipart/form-data">

                                <input type="hidden" name="documento" value="<?= htmlspecialchars($datos['documento']) ?>">
                                <div class="seccion">
                                    <h3> Datos federación </h3>
                                    <div class="form-col">
                                    <div class="form-col-left">
                                    <div>
                                                <label for="federacion">Federación</label>
                                                <select id="federacion" name="federacion">
                                                <?php foreach ($federaciones as $federacion): ?>
                                                    <option value="<?= $federacion['federacion'] ?>" <?= isset($datos['federacion']) && $datos['federacion'] == $federacion['federacion'] ? 'selected' : '' ?> required>
                                                        <?= htmlspecialchars($federacion['federacion']) ?>
                                                    </option>
                                                <?php endforeach; ?>
                                                    </select>
                                    </div>
                                    <div>
                                                <label for="federado">Estado:</label>
                                                <input type="text" id="federado" name="federado" value="<?= htmlspecialchars($datos['federado']) ?>" >
                                                <p>1= Federado, 0= No Federado</p>
                                    
                                    </div>
                                    <div>
                                                <label for="lic">Estado Licencia:</label>
                                                <input type="text" id="lic" name="lic" value="<?= htmlspecialchars($datos['lic']) ?>" >
                                        </div>
                                        <div>
                                                <label for="licencia">N° Licencia</label>
                                                <input type="text" id="licencia" name="licencia" value="<?= htmlspecialchars($datos['licencia']) ?>">
                                        </div>


                                                </div>
                                <div class="form-col-rig">
                                    <div>
                                    <label for="foto">Foto</label>
                                        <?php if ($foto_existe): ?>
                                            <div>
                                                <img src="<?= htmlspecialchars($foto_path1) ?>" alt="Foto del usuario" style="width: 200px; height: 200px;">
                                                <input type="file" id="foto" name="foto" accept="image/*">
                                            </div>
                                        <?php elseif (!$foto_existe): ?>
                                            <div>
                                                <img src="..\sinfoto.png" alt="Foto del usuario" style="max-width: 200px; max-height: 200px;">
                                                <input type="file" id="foto" name="foto" accept="image/*">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div> 
                                </div> 
                                    <hr>
                                    <div class="seccion">
                                    <h3> Datos del solicitante </h3>
                                    <div class="form-row">
                                            <div>
                                                <label for="licenciaanio">Licencia Año:</label>
                                                <input type="text" id="licenciaanio" name="licenciaanio" value="<?= htmlspecialchars($anios['licenciaanio']) ?>" >
                                            </div>
                                            <div>
                                                <label for="uci">Código UCI:</label>
                                                <input type="text" id="uci" name="uci" value="<?= htmlspecialchars($datos['uci'] ?? '') ?>" >
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="Nombre">Nombre:</label>
                                                <input type="text" id="Nombre" name="Nombre" value="<?= htmlspecialchars($datos['Nombre']) ?>" >
                                            </div>
                                            <div>
                                                <label for="apellidos">Apellido:</label>
                                                <input type="text" id="apellidos" name="apellidos" value="<?= htmlspecialchars($datos['apellidos']) ?>" >
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div>
                                                <label for="genero">Género:</label>
                                                <input type="text" id="genero" name="genero" value="<?= htmlspecialchars($datos['genero']) ?>" onchange="calcularEdad()">
                                            </div>
                                            <div>
                                                <label for="fechanac">Fecha de Nacimiento:</label>
                                                <input type="date" id="fechanac" name="fechanac" value="<?= DateTime::createFromFormat('d/m/Y', $datos['fechanac'])->format('Y-m-d') ?>"  onchange="calcularEdad()">
                                            </div>
                                            <div>
                                        <label for="edadanios">Edad en Años:</label>
                                        <input type="text" id="edadanios" name="edadanios" value="<?= htmlspecialchars($edadAnios) ?>" >
                                    </div>
                                    <div>
                                                <label for="nacionalidad">Nacionalidad:</label>
                                                <input type="text" id="nacionalidad" name="nacionalidad" value="<?= htmlspecialchars($datos['nacionalidad']) ?>" >
                                                    </div>
                                                    
                                        </div>
                                                </div>
                                                <hr>
                                        <div class="seccion">
                                    <h3> Actualización de datos </h3>
                                        <div class="form-row">
                                            <div>
                                                <label for="peso">Peso (Unidad Kgs. [000.00]):</label>
                                                <input type="number" id="peso" name="peso" step="0.01" value="<?= htmlspecialchars($datos['peso']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="altura">Altura (Centimetros [000]):</label>
                                                <input type="number" id="altura" name="altura" value="<?= htmlspecialchars($datos['altura']) ?>" required>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="os">Obra Social:</label>
                                                <input type="text" id="os" name="os" value="<?= htmlspecialchars($datos['os']) ?>" required>
                                            </div>

                                            <div>
                                                <label for="vacunado">Vacunado COVID:</label>
                                                <select id="vacunado" name="vacunado" required>
                                                <option value="" <?= !isset($datos['vacunado']) || $datos['vacunado'] === '' ? 'selected' : '' ?>>Seleccione una opción</option>
                                                <option value="SI" <?= $datos['vacunado'] === 'SI' ? 'selected' : '' ?>>Sí</option>
                                                <option value="NO" <?= $datos['vacunado'] === 'NO' ? 'selected' : '' ?>>No</option>
                                                </select>
                                            </div>
                                        </div>


                                        <div class="form-row">
                                        <div>
                                                <label for="club">Club:</label>
                                                <input type="text" id="club" name="club" value="<?= htmlspecialchars($datos['club']) ?>">
                                            </div>
                                            <div>
                                                <label for="opseguro">Opción Seguro:</label>
                                                    <select id="opseguro" name="opseguro" required>
                                                        <?php foreach ($opseguros as $opseguro) {
                                                            $opseguroselected = $datos['opseguro'] ?? '';
                                                            $selected = $opseguro === $datos['opseguro'] ? 'selected' : '';
                                                            echo "<option value=\"$opseguro\" $selected>$opseguro</option>";
                                                        }
                                                        ?>
                                                    </select>
                                            </div>

                                        </div>

                                        <div class="form-row">
                                        <div>
                                            <label for="categoria0">Categoría:</label>
                                            <select id="categoria0" name="categoria0" required>
                                                <option value="">Seleccione una categoría</option>
                                                <?php
                                                // Obtener la categoría actual si existe
                                                $categoriaactual = htmlspecialchars(explode(' - ', $datos['categoria'])[0] ?? '');

                                                // Generar las opciones del select
                                                foreach ($categorias0 as $categoria0) {
                                                    $selected = $categoria0 === $categoriaactual ? 'selected' : '';
                                                    echo "<option value=\"$categoria0\" $selected>$categoria0</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                            <div>
                                            <label for="categoria1">Sub Categoría:</label>
                                            <input type="hidden" id="cate1actual" value="<?php echo htmlspecialchars(explode(' - ', $datos['categoria'])[1] ?? ''); ?>">
                                            <select id="categoria1" name="categoria1">
                                                <option value="">Seleccione una subcategoría</option>
                                               
                                            </select>
                                            </div>
                                    
                                    </div>
                                    <hr>
                                        <div class="subseccion">
                                            <h4>Información de Contacto</h4>
                                        <div class="form-row">
                                            <div>
                                                <label for="localidad">Localidad:</label>
                                                <input type="text" id="localidad" name="localidad" value="<?= htmlspecialchars(explode(' - ', $datos['ciudad'])[0]) ?>" required>
                                            </div>
                                    <div>
                                        <label for="provincia">Provincia:</label>
                                        <select id="provincia" name="provincia" required>
                                            <option value="">Seleccione una provincia</option>
                                            <?php
                                            // Lista de provincias de Argentina
                                            $provincias = [
                                                'CABA', 'Buenos Aires', 'Catamarca', 'Chaco', 'Chubut', 'CORDOBA', 'Corrientes', 
                                                'Entre RIos', 'Formosa', 'Jujuy', 'La Pampa', 'La Rioja', 'Mendoza', 
                                                'Misiones', 'NeuquEn', 'RIo Negro', 'Salta', 'San Juan', 'San Luis', 
                                                'Santa Cruz', 'Santa Fe', 'Santiago del Estero', 'Tierra del Fuego', 'TucumAn'
                                            ];
                                            $provincias = array_map('strtoupper', $provincias);

                                            // Obtener la provincia seleccionada si existe
                                            $provinciaSeleccionada = htmlspecialchars(explode(' - ', $datos['ciudad'])[1] ?? '');

                                            // Generar las opciones del select
                                            foreach ($provincias as $provincia) {
                                                $selected = $provincia === $provinciaSeleccionada ? 'selected' : '';
                                                echo "<option value=\"$provincia\" $selected>$provincia</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="calle">Calle:</label>
                                                <input type="text" id="calle" name="calle" value="<?= htmlspecialchars($datos['calle']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="telefono">Teléfono:</label>
                                                <input type="text" id="telefono" name="telefono" value="<?= htmlspecialchars($datos['telefono']) ?>" required>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="email">Email:</label>
                                                <input type="email" id="email" name="email" value="<?= htmlspecialchars($datos['email']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="emergencia">Emergencia:</label>
                                                <input type="text" id="emergencia" name="emergencia" value="<?= htmlspecialchars($datos['emergencia']) ?>" required>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div>
                                                <label for="telemergencia">Teléfono de Emergencia:</label>
                                                <input type="text" id="telemergencia" name="telemergencia" value="<?= htmlspecialchars($datos['telemergencia']) ?>" required>
                                            </div>
                                            <div>
                                                <label for="emailcontacto">Email de Contacto:</label>
                                                <input type="email" id="emailcontacto" name="emailcontacto" value="<?= htmlspecialchars($datos['emailcontacto']) ?>" required>
                                            </div>
                                        </div>


                                                    <div class="button-container">
                                                    <a id="cancelar" type="" href="bienvenida.php">Cancelar</a>
                                                    <button type="submit">Guardar Cambios</button>
                                                    </div>
                            </form>
                            <?php endif; ?>
                            <div class="popup">
        <h2>CORREDOR EDITADO CORRECTAMENTE</h2>
        <div class="popup-content">
            <?php
            foreach ($modified_data as $field => $value) {
        echo "<p><strong>" . $labels[$field] . ":</strong> $value</p>";
            }
            ?>
        </div>
        <button onclick="window.location.href='bienvenida.php'">Volver al inicio</button>
    </div>


    

</body>
</html>