<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso < 0 && $nivel_acceso != 3 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}
// Incluir la configuración de la base de datos
include('config/db.php');
include('config/editar_carrera_data.php');
require('header.php');


?>

<!DOCTYPE html>
<html lang="es">
   
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=12434">
    <link rel="stylesheet" type="text/css" href="styles.css?id=12434">
    <script src="config/scripts.js?id=1323323" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/@zxing/library@0.18.4/umd/index.min.js"></script>
    <script src="config/edit_carrera.js?id=14323" defer></script>
    <title>Carreras</title>
    <style>
         .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            max-width:100%;
           
        }

        .column-left {
            flex-basis: 30%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
    margin: 30px 0px;
background-color: white;

    border-radius: 0px 8px 8px 0px;
    box-shadow: 3px 3px 3px #2e86c1;
    width: 30%;
    color: white;
        }
    #titulo {
color: #2e86c1;;
    

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        @media (max-width: 768px) {
    .column-container {
        flex-direction: column;
    }
    .inner {
        width: 100%;
        padding: 20px 0px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    video {
        margin-top: 40px;
        width: 300px;
    height: 100px;
    content: stretch;
    object-fit: cover;
    }
}
        
    </style>
    
</head>

<body>
    </div>
        <div class="column-container">
            <div class="column-left">
                <div class="inner buscar">
                    <h3>Detalles de la Carrera</h3>
                    <?php if($carrera['cerrada'] == 0): ?>
                        <h2 style="background-color:green;color:white;padding:15px;margin:10px;border-radius:3rem">Inscripciones ABIERTAS</h2>
                    <?php else: ?>
                    <h2 style="background-color:red;color:white;padding:15px;margin:10px;border-radius:3rem">Inscripciones cerradas.</h2>
                    <?php endif; ?>
                            <table class="detalle">
                                <tr>
                                    <td class="label">Nombre de la Carrera:</td>
                                    <td><?php echo htmlspecialchars($carrera['nombre_carrera']); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Fecha de la Carrera:</td>
                                    <td><?php echo htmlspecialchars($carrera['fecha_carrera']); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Lugar de la Carrera:</td>
                                    <td><?php echo htmlspecialchars($carrera['lugar_carrera']); ?></td>
                                </tr>
                                <tr>
                                    <td class="label">Federación de la Carrera:</td>
                                    <td><?php echo htmlspecialchars($carrera['federacion_carrera']); ?></td>
                                </tr>
                            </table>
                    <?php if($carrera['cerrada'] == 0): ?>
                        <form action="config/cerrar_carrera.php" method="post">
                            <input type="hidden" id="carrera_id" name="carrera_id" value="<?php echo $carrera['id']; ?>">
                            <input type="submit" value="Cerrar Carrera" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-top: 20px;">
                        </form>
                    <?php else: ?>
                    <?php endif; ?>
                </div>
                <?php if($carrera['cerrada'] == 0): ?>
                <div class="inner">
                    <h3>Agregar Corredor</h3>       
                        <form id="searchForm" action="" method="post" style="position: relative; display: inline-block; margin-bottom: 20px;">
                            <input type="text" id="documento" name="documento" value="" onkeyup="showSuggestions1(this.value)" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
                            <input type="hidden" id="carrera_id" name="id" value="<?php echo $carrera['id']; ?>">
                            <input id="enviar" type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
                            <div id="suggestions" style="display: none;"></div>
                        </form>
                        <h1>Escanear Licencia</h1>
                        <button id="startButton">Iniciar Escaneo</button>
                        <video id="video" width="100%" height="100px"></video>
                        <div id="result"></div>
                </div>         
                <?php else: ?>
                <div class="inner">
                    <h3>Descargar reporte</h3>       
                    <a class="export" href="exportar_empadronado.php?id=<?php echo $carrera['id']; ?>" class="button">Exportar a Excel</a>             
                </div>    
                <?php endif; ?>         
            </div>

    
        <div class="column-right" style="min-height: 200px;">
            <div class="inner">
                <?php if (isset($_SESSION['success_msg'])): ?>
                        <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
                    <?php unset($_SESSION['success_msg']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error_msg'])): ?>
                        <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
                <?php unset($_SESSION['error_msg']); ?>
                <?php endif; ?>
                <h3>Corredores Empadronados</h3>
                    <table>
                        <thead>
                            <tr>
                                <th class="<?php echo $columna == 'documento' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('documento')" >DNI</th>
                                <th class="<?php echo $columna == 'Nombre' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('Nombre')" >Nombre</th>
                                <th class="<?php echo $columna == 'apellidos' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('apellidos')" >Apellidos</th>
                                <th class="<?php echo $columna == 'categoria' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('categoria')" >Categoría</th>
                                <th class="<?php echo $columna == 'uci' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('uci')" >UCI</th>
                                <th class="<?php echo $columna == 'time' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('time')" >Registro</th>

                            </tr>
                        <thead>
                        <tbody>
                            <?php foreach ($corredores as $corredor): ?>
                                <tr>
                                    <td data-label="Documento"><?php echo htmlspecialchars($corredor['documento']); ?></td>
                                    <td data-label="Nombre"><?php echo htmlspecialchars($corredor['Nombre']); ?></td>
                                    <td data-label="Apellido"><?php echo htmlspecialchars($corredor['apellidos']); ?></td>
                                    <td data-label="Categoría"><?php echo htmlspecialchars($corredor['categoria']); ?></td>
                                    <td data-label="UCI"><?php echo htmlspecialchars($corredor['uci'] ?? ''); ?></td>
                                    <td data-label="Registro"><?php echo htmlspecialchars($corredor['time']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <div class="pagination">
                            <?php if ($pagina_actual > 1): ?>
                                <a href="editar_carrera.php?id=<?php echo $carrera['id']; ?>&page=<?php echo $pagina_actual - 1; ?>">&laquo;</a>
                            <?php endif; ?>
                            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                                <a href="editar_carrera.php?id=<?php echo $carrera['id']; ?>&page=<?php echo $i; ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                                    <?php echo $i; ?>
                                </a>
                            <?php endfor; ?>
                            <?php if ($pagina_actual < $total_paginas): ?>
                                <a href="editar_carrera.php?id=<?php echo $carrera['id']; ?>&page=<?php echo $pagina_actual + 1; ?>">&raquo;</a>
                            <?php endif; ?>
                </div>
            </div>
        </div>
    </div>


    <div id="myModal8" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal8()">&times;</span>
            <h2>Resultados de la Búsqueda</h2>
            <div id="modal-body"></div>
        </div>
    </div>
</body>
</html>