<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];


// Aseguramos que el id del campeonato esté disponible
$id_campeonato = isset($_GET['id']) ? $_GET['id'] : 1; // Suponemos que el id se pasa en la URL

// Obtener las pruebas existentes para este campeonato
$sql = "SELECT * FROM pruebas_campeonatos WHERE id_campeonato = :id_campeonato";
$stmt = $conn->prepare($sql);
$stmt->bindParam(':id_campeonato', $id_campeonato, PDO::PARAM_INT);
$stmt->execute();
$pruebas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Verificar el nivel de acceso
if ($nivel_acceso <> 2 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}



// Incluir la configuración de la base de datos
include('config/db.php');
include('config/editar_campeonato_data.php');
include('config/campeonato_cat.php');
require('header.php');
// Obtener las categorías asociadas al campeonato
$sql = "SELECT categoria FROM campeonato_cat WHERE id_campeonato = :id_campeonato";
$stmt = $conn->prepare($sql);
$stmt->bindParam(':id_campeonato', $id_campeonato, PDO::PARAM_INT);
$stmt->execute();
$categorias_asociadas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Crear un array con los IDs de las categorías asociadas para poder marcarlas como seleccionadas
$categorias_seleccionadas = [];
foreach ($categorias_asociadas as $categoria) {
    $categorias_seleccionadas[] = $categoria['categoria'];
}


?>

<!DOCTYPE html>
<html lang="es">
   
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=12434">
    <link rel="stylesheet" type="text/css" href="styles.css?id=12434">
    <script src="config/scripts.js?id=13223" defer></script>
    <title>Campeonatos</title>
    <style>
         .column-container {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            width: max-content;
           
        }
        .column-container1 {
            display: flex;
            flex-direction: row;
            justify-content: center;
           
        }

        .column-left {
            flex-basis: 40%;
            padding: 20px;

        }
        .inner {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .top {
            padding: 20px;
            margin: auto;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: inset 0 -3px 3px rgba(0, 0, 0, 0.1);

        }

        .buscar {
            margin-bottom: 20px;
        }

        .column-right {
            flex-grow: 1;
            padding: 20px;
        }

        .column + .column {
            margin-left: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 1rem;
 
        }

        td {
            padding: 10px;
            vertical-align: top;
            border: none;
        }

        td.label {
            font-weight: bold;
     
            width: 60%;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
        }

        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 50%;
        }

        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        th {
            cursor: pointer;
            text-align: left;
        }
        th.sorted-asc::after {
            content: ' ↑';
        }
        th.sorted-desc::after {
            content: ' ↓';
        }
        @media (max-width: 768px) {
            .column-container {
        flex-direction: column;
    }
    .inner {
   
        padding: 15px;
    }
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    tbody {
        margin-left: 15px;
    }
    body > div.column-container > div.column-right > div > table > tbody > tr > td:nth-child(1) {
        border-top: 2px solid #ccC;
    }
    .detalle td {
        padding-left: 20px;
        width: 80% !important;
    }
    td.label {
            font-weight: bold;
     
            width: 20%;
        }
}
        
    </style>
    
</head>

<body>

        <div class="column-container1">
        <div class="column-container">
            <div class="column-left">
                <div class="inner buscar">
                    <h3>Detalles del Campeonato</h3>
                    <?php if (isset($_SESSION['success_msg'])): ?>
                        <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
                    <?php unset($_SESSION['success_msg']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error_msg'])): ?>
                        <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
                <?php unset($_SESSION['error_msg']); ?>
                <?php endif; ?>
                    <form method="post">
                        <table class="detalle">
                            <tr>
                                <td class="label">Nombre del campeonato:</td>
                                <td><input type="text" id="campeonato_nombre" value="<?php echo isset($campeonato['campeonato_nombre']) ? $campeonato['campeonato_nombre'] : ''; ?>" name="campeonato_nombre" placeholder="Nombre del campeonato" required></td>
                            </tr>
                            <tr>
                                <td class="label">Fecha:</td>
                                <td><input type="date" id="campeonato_fecha" value="<?php echo isset($campeonato['campeonato_fecha']) ? $campeonato['campeonato_fecha'] : ''; ?>" name="campeonato_fecha" required></td>
                            </tr>
                            <tr>
                                <td class="label">Lugar:</td>
                                <td><input type="text" id="campeonato_lugar" value="<?php echo isset($campeonato['campeonato_lugar']) ? $campeonato['campeonato_lugar'] : ''; ?>" name="campeonato_lugar" placeholder="Lugar Campeonato" required></td>
                            </tr>
                            <tr>
                                <td><input type="hidden" id="activo" value="<?php echo isset($campeonato['activo']) ? $campeonato['activo'] : ''; ?>" name="activo" placeholder="1 = activo" required></td>
                                <td><input type="hidden" id="id" value="<?php echo isset($campeonato['id']) ? $campeonato['id'] : ''; ?>" name="id" required></td>
                            </tr>
                        </table>
                        <div class="button-container">
                        <a id="cancelar" type="" href="campeonatos.php">Volver</a>
                         <button type="submit">Guardar Cambios</button> 
                                                    </div>
                    </form>
                </div>
                    <div class="inner">
                    <h3>Inscripciones al campeonato</h3>
                    <?php if($campeonato['activo'] == 1): ?>
                        <h2 style="color:green">Inscripciones ABIERTAS</h3>

                        <form action="config/cerrar_campeonato.php" method="post">
                            <input type="hidden" id="id" name="id" value="<?php echo $campeonato['id']; ?>">
                            <input type="hidden" id="cerrar" name="cerrar" value="0">
                            <input type="submit" value="Cerrar Inscripciones" style="padding: 10px 20px; border: none; border-radius: 5rem; background-color:#c0392b; color: #fff; cursor: pointer; margin-top: 20px;">
                        </form>
                    <?php else: ?>
                    <p style="color: red;">Campeonato cerrado.</p>
                    <form action="config/cerrar_campeonato.php" method="post">
                            <input type="hidden" id="id" name="id" value="<?php echo $campeonato['id']; ?>">
                            <input type="hidden" id="cerrar" name="cerrar" value="1">
                            <input type="submit" value="Abrir Inscripciones" style="padding: 10px 20px; border: none; border-radius: 5rem; background-color:rgb(88, 122, 65); color: #fff; cursor: pointer; margin-top: 20px;">
                        </form>
                    <?php endif; ?>
                </div>
                     
            </div>

    
        <div class="column-right" style="min-height: 200px;">
            <div class="inner" style="
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
">
                <h3>Pruebas del Campeonato</h3>
                <?php if (isset($_SESSION['success_msg'])): ?>
                        <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
                    <?php unset($_SESSION['success_msg']); ?><?php endif;?>
                <form method="POST" action="config/guardar_pruebas.php">
                <input type="hidden" name="id_campeonato" value="<?php echo $id_campeonato; ?>">

    <table class="detalle" id="tabla_pruebas">
        <thead>
            <tr>
                <th>Nombre de la prueba</th>
                <th>Género</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
    <!-- Mostrar las pruebas existentes -->
    <?php
    if($campeonato['activo'] == 1) {
    if ($pruebas) {
        foreach ($pruebas as $prueba) {
            echo '<tr class="fila_prueba">
                    <td><input type="text" name="nombre_prueba[]" value="' . htmlspecialchars($prueba['nombre_prueba']) . '" placeholder="Nombre de la prueba" disabled></td>
                    <td>
                        <select name="genero[]" disabled>
                            <option value="F"' . ($prueba['genero'] == 'F' ? ' selected' : '') . '>F</option>
                            <option value="M"' . ($prueba['genero'] == 'M' ? ' selected' : '') . '>M</option>
                        </select>
                    </td>
                    <td>
                        <button type="button" onclick="eliminarFila(this, ' . $prueba['id'] . ')">Eliminar</button>
                    </td>
                  </tr>';
        }
    } else {
        echo '<tr class="fila_prueba">
                <td><input type="text" name="nombre_prueba[]" placeholder="Nombre de la prueba" required></td>
                <td>
                    <select name="genero[]" required>
                        <option value="F">F</option>
                        <option value="M">M</option>
                    </select>
                </td>
                <td><button type="button" onclick="eliminarFila(this)">Eliminar</button></td>
              </tr>';
    }

} else {
    if ($pruebas) {
        foreach ($pruebas as $prueba) {
            echo '<tr class="fila_prueba">
                    <td><input type="text" name="nombre_prueba[]" value="' . htmlspecialchars($prueba['nombre_prueba']) . '" placeholder="Nombre de la prueba" disabled></td>
                    <td>
                        <select name="genero[]" disabled>
                            <option value="F"' . ($prueba['genero'] == 'F' ? ' selected' : '') . '>F</option>
                            <option value="M"' . ($prueba['genero'] == 'M' ? ' selected' : '') . '>M</option>
                        </select>
                    </td>
                   
                  </tr>';
        }
    } else {
        echo '<tr class="fila_prueba">
                <td><input type="text" name="nombre_prueba[]" placeholder="Nombre de la prueba" required></td>
                <td>
                    <select name="genero[]" required>
                        <option value="F">F</option>
                        <option value="M">M</option>
                    </select>
                </td>
                
              </tr>';
    }

}
    ?>
</tbody>
    </table>
    <?php if($campeonato['activo'] == 1): ?>
    <button type="button" onclick="agregarFila()">Agregar otra prueba</button><br><br>
    <input type="submit" value="Guardar Pruebas" style="padding: 10px 20px; border: none; border-radius: 50px; background-color: #2e86c1; color: #fff; cursor: pointer;">
        <?php endif; ?>
</form>
                       
                </div>
            </div>


            <div class="column-right" style="min-height: 200px;">
<div class="inner">
    <h3>Agregar Categorías al Campeonato</h3>
    <form method="POST" action="config/campeonato_cat.php">
        <input type="hidden" name="id_campeonato" value="<?php echo $campeonato['id']; ?>">
        
        <label for="categorias">Selecciona las categorías:</label>
        <select name="categorias[]" id="categorias" multiple required onmouseover="ajustarAlturaSelect()">
            <?php 
            // Mostrar todas las categorías disponibles
            foreach ($categorias as $categoria): 
                // Verificar si la categoría está asociada al campeonato
                $seleccionada = in_array($categoria['categoria'], $categorias_seleccionadas) ? 'selected' : '';
            ?>
                <option value="<?php echo $categoria['categoria']; ?>" <?php echo $seleccionada; ?>>
                    <?php echo htmlspecialchars($categoria['categoria']); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <br><br>
            <?php if($campeonato['activo'] == 1): ?>

        <button type="submit">Agregar Categorías</button>
          <?php endif; ?>
    </form>
</div>
</div>
</div>
</div>


    <div id="myModal8" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal8()">&times;</span>
            <h2>Resultados de la Búsqueda</h2>
            <div id="modal-body"></div>
        </div>
    </div>
</body>

<script>
    function ajustarAlturaSelect() {
        var select = document.getElementById('categorias');
        var numOpciones = select.options.length; // Número de opciones en el select
        var altura = 30 * numOpciones; // Establece la altura dependiendo del número de opciones

        // Establecer una altura máxima
        if (altura > 300) altura = 700; 

        select.style.height = altura + 'px'; // Ajustar la altura del select
    }
</script>

</html>
