<?php
// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];

/// Manejo de búsqueda
$documento = isset($_GET['documento']) ? trim($_GET['documento']) : '';

// Configuración de paginación
$registros_por_pagina = 20;
$pagina_actual = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$inicio_registro = ($pagina_actual - 1) * $registros_por_pagina;

// Construcción de la consulta
$sql = "SELECT * FROM users where federado = 1 and fecha_pago is not null  and (uci is null or uci ='')";
$params = [];

// Aplicar filtro de federación solo si federacion_id_usuario no es 1


// Agregar filtro por documento si corresponde
if ($documento !== '') {
    $sql .= ($federacion_id_usuario != 1 ? " AND" : " and") . " documento LIKE :documento";
    $params[':documento'] = "%$documento%";
}

// Ejecutar la consulta para obtener el número total de registros
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$total_registros = $stmt->rowCount();

    // Calcular total de páginas
    $total_paginas = ceil($total_registros / $registros_por_pagina);

    // Agregar límite para la paginación
    $sql .= " LIMIT $inicio_registro, $registros_por_pagina";

    // Ejecutar consulta con paginación
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $registros = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    


?>