
document.addEventListener('DOMContentLoaded', () => {
    cargaruci();
    mostrardatos();
});


function cargaruci() {
    const botones = document.querySelectorAll('#tabla tbody tr td a#uci'); // Selecciona solo los botones

    // Agregar un evento de clic a cada botón
    botones.forEach(boton => {
        boton.addEventListener('click', (event) => {
            // Evitar que el evento afecte otros elementos
 event.preventDefault();
            try {
                // Obtener la fila de la que proviene el botón clickeado
                const fila = boton.closest('tr'); // Encuentra la fila más cercana al botón
                const documento = fila.querySelector('.documento').textContent;

                // Mostrar el valor en el input con id 'documento'
                document.getElementById('documentouci').value = documento;
                document.getElementById('myModal').style.display = "block";
            } catch (error) {
                console.error('Error:', error);
            }
        });
    });
}



function mostrardatos() {
    const botones = document.querySelectorAll('#tabla tbody tr td a#datos'); // Selecciona solo los botones

    // Agregar un evento de clic a cada botón
    botones.forEach(boton => {
        boton.addEventListener('click', (event) => {
            // Evitar que el enlace haga su acción por defecto
 event.preventDefault();

            // Encontrar la fila correspondiente al botón clickeado
            const fila = boton.closest('tr');

            // Obtener los valores de la fila seleccionada
            const documento = fila.querySelector('.documento').textContent;
            const nombre = fila.querySelector('.Nombre').textContent;
            const apellidos = fila.querySelector('.apellidos').textContent;
            const fechanac = fila.querySelector('.fechanac').textContent;
            const genero = fila.querySelector('.genero').textContent;
            const nacionalidad = fila.querySelector('.nacionalidad').textContent;
            const federacion = fila.querySelector('.federacion').textContent;
            const categoria = fila.querySelector('.categoria').textContent;
            const licencia = fila.querySelector('.licencia').textContent;

            // Obtener el cuerpo del modal
            var modalBody = document.getElementById('modal-body1');
            modalBody.innerHTML = ''; // Limpiar el contenido anterior del modal

            // Llenar el modal con los datos de la fila seleccionada
            modalBody.innerHTML = `
                <div class="column-total">
                    <p><strong>Nombre:</strong> ${nombre}</p>
                    <p><strong>Apellido:</strong> ${apellidos}</p>
                    <p><strong>Documento:</strong> ${documento}</p>
                    <p><strong>Fecha Nacimiento:</strong> ${fechanac}</p>
                    <p><strong>Federación:</strong> ${federacion}</p>
                    <p><strong>Categoria:</strong> ${categoria}</p>
                    <p><strong>Género:</strong> ${genero}</p>
                    <p><strong>Nacionalidad:</strong> ${nacionalidad}</p>
                    <p><strong>Nro Licencia:</strong> ${licencia}</p>
                </div>
            `;

            // Mostrar el modal
            document.getElementById('myModal9').style.display = 'block';
        });
    });
}
        function closeModal9() {
            document.getElementById('myModal9').style.display = "none";
        }

        // Cerrar la ventana modal cuando el usuario hace clic fuera de ella
        window.onclick = function(event) {
            if (event.target == document.getElementById('myModal9')) {
                closeModal();
            }
        }
        
                function closeModal() {
            document.getElementById('myModal').style.display = "none";
        }

        // Cerrar la ventana modal cuando el usuario hace clic fuera de ella
        window.onclick = function(event) {
            if (event.target == document.getElementById('myModal')) {
                closeModal();
            }
        }
