document.getElementById('searchForm').addEventListener('submit', function(event) {
    event.preventDefault();
    var documento = document.getElementById('documento').value;

    fetch('config/buscar_corredor_carrera.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';
        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
            <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Email:</strong> ${data.email}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                
            </div>
            <div class="column-right">
            
           <form action="config/suspender_corredor.php" method="post">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <label> Fecha Suspensión desde</label>
                <input type="date" id="fecha_desde" name="fecha_desde" requeried>
                <label> Fecha Suspensión hasta</label>
                <input type="date" id="fecha_hasta" name="fecha_hasta" requeried>
                                <label>Acta</label>
                <input type="text" id="acta" name="acta" requeried>
                <input id="enviar" type="submit" value="Suspender" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            </form>

            </div>
            </div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });
});

function closeModal8() {
    document.getElementById('myModal8').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target == document.getElementById('myModal8')) {
        closeModal8();
    }
}

function ordenar(columna) {
    const urlParams = new URLSearchParams(window.location.search);
    const currentOrder = urlParams.get('orden') === 'desc' ? 'asc' : 'desc';
    urlParams.set('columna', columna);
    urlParams.set('orden', currentOrder);
    window.location.search = urlParams.toString();
}


function selectSuggestion1(documento) {
    document.getElementById("documento").value = documento;
    document.getElementById("suggestions").style.display = "none";
    


    fetch('config/buscar_corredor_carrera.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';

        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
        <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Email:</strong> ${data.email}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                
            </div>
            <div class="column-right">
            
           <form action="config/suspender_corredor.php" method="post">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <label> Fecha Suspensión desde</label>
                <input type="date" id="fecha_desde" name="fecha_desde" requeried>
                <label> Fecha Suspensión hasta</label>
                <input type="date" id="fecha_hasta" name="fecha_hasta" requeried>
                <label>Acta</label>
                <input type="text" id="acta" name="acta" requeried>
                <input id="enviar" type="submit" value="Suspender" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            </form>

            </div>
            </div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });


}
       
function filterTable() {
    var checkbox = document.getElementById('filterSuspendido');
    var rows = document.querySelectorAll('#tabla tbody tr');
    rows.forEach(function(row) {
        var estado = row.cells[6].innerText;
        if (checkbox.checked) {
            if (estado !== 'Suspendido') {
                row.style.display = '';
            } else {
                row.style.display = '';
        } }else {if (estado == 'Suspendido') {
            row.style.display = '';
            row.style.background = '#f2d7d5';

        }else {
                row.style.display = 'none';
            }}
        
    });}



function eliminarsuspension() {

    const filas = document.querySelectorAll('#tabla tbody tr');

    // Agregar un evento de clic a cada fila
    filas.forEach(fila => {
        fila.addEventListener('click', () => {
            // Obtener el valor de la columna 'documento' de la fila seleccionada
            const documento = fila.querySelector('.documento').textContent;
            const id = fila.querySelector('.id').textContent;
            // Mostrar el valor en el párrafo con id 'resultado'
          


    fetch('config/buscar_corredor_suspendido.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body1');
        modalBody.innerHTML = '';

        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
                    
            <div class="column-total">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Email:</strong> ${data.email}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                <form action="config/desuspender_corredor.php" method="post">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <input type="hidden" id="id" name="id" value="${id}">
                <input id="enviar" type="submit" value="Sacar Suspensión" style="padding: 10px 20px; border: none; border-radius: 4px; background-color:rgb(59, 141, 127); color: #fff; cursor: pointer; margin-left: 10px;">
            </form>
            </div>
            </div>

            `;
        }

        document.getElementById('myModal9').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });

});
});

}


function closeModal9() {
    document.getElementById('myModal9').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target == document.getElementById('myModal9')) {
        closeModal9();
    }
}





