<?php
session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');


// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documento'];
    $fecha_desde = $_POST['fecha_desde'];
    $fecha_hasta = $_POST['fecha_hasta'];
    $acta = $_POST['acta'];


    // Verificar que los datos no estén vacíos
    if (empty($fecha_desde) || empty($documento) || empty($fecha_hasta)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../suspendidos.php');

        exit();
    }

    $hoy = date('Y-m-d');
    // Verificar que el corredor no esté ya registrado en la carrera
    $stmt = $conn->prepare("
    SELECT u.documento, u.Nombre, u.apellidos, u.categoria, u.suspendido, u.federacion, s.fecha_desde, s.fecha_hasta 
    FROM users u 
    JOIN suspensiones s ON u.documento = s.documento 
    WHERE s.fecha_desde <= :hoy AND s.fecha_hasta >= :hoy AND u.documento = :documento
");
    $stmt->bindParam(':hoy', $hoy, PDO::PARAM_STR);
    $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);

    $stmt->execute();

    if ($stmt->rowCount() > 0) {

        $_SESSION['error_msg'] = "El corredor ya tiene una suspensión activa";
        header('Location: ../suspendidos.php' );
        exit();
    }



    // Actualizar otra tabla (por ejemplo, pagos)
    $sql2 = "INSERT INTO suspensiones SET documento = :documento, acta = :acta, fecha_desde = :fecha_desde, fecha_hasta = :fecha_hasta";
    $stmt2 = $conn->prepare($sql2);
    $stmt2->bindParam(':acta', $acta, PDO::PARAM_STR);

    $stmt2->bindParam(':fecha_desde', $fecha_desde, PDO::PARAM_STR);
    $stmt2->bindParam(':fecha_hasta', $fecha_hasta, PDO::PARAM_STR);
    $stmt2->bindParam(':documento', $documento, PDO::PARAM_STR);

    $success2 = $stmt2->execute();

    $sql3 = "UPDATE users SET suspendido = 1, lic = 'Suspendida' where documento = :documento";
    $stmt3 = $conn->prepare($sql3);
    $stmt3->bindParam(':documento', $documento, PDO::PARAM_STR);

    $success3 = $stmt3->execute();

    if ($success2 && $success3) {
        $_SESSION['success_msg'] = "DNI $documento suspendido.";
       } else {
        // Obtener información del error
        $errorInfo2 = $stmt2->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar la suspensión " . $errorInfo2[2];
    }

    // Redirigir de vuelta a la página de pagos masivos
    header('Location: ../suspendidos.php' );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos masivos
    header('Location: ../suspendidos.php' );
    exit();
}


?>