<?php
// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];


$sql_seguros = "SELECT fecha_seguro, COUNT(*) as cantidad FROM users where federado = 1 and fecha_pago is not null GROUP BY fecha_seguro ORDER BY fecha_seguro ASC";
$stmt_seguros = $conn->prepare($sql_seguros);
$stmt_seguros->execute();
$seguros = $stmt_seguros->fetchAll(PDO::FETCH_ASSOC);

// Manejo de búsqueda
$documento = isset($_GET['documento']) ? trim($_GET['documento']) : '';

// Configuración de paginación
$registros_por_pagina = 20;
$pagina_actual = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$inicio_registro = ($pagina_actual - 1) * $registros_por_pagina;

// Construcción de la consulta
$sql = "SELECT * FROM users where federado = 1 and fecha_pago is not null";



// Ejecutar la consulta para obtener el número total de registros
$stmt = $conn->prepare($sql);
$stmt->execute();
$total_registros = $stmt->rowCount();

// Calcular total de páginas
$total_paginas = ceil($total_registros / $registros_por_pagina);

// Agregar límite para la paginación
$sql .= " LIMIT $inicio_registro, $registros_por_pagina";

// Ejecutar consulta con paginación
$stmt = $conn->prepare($sql);
$stmt->execute();
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
