<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();

// Conexión a la base de datos
include('db.php');

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documentouci'];
    $uci = $_POST['uci'];

    // Verificar que los datos no estén vacíos
    if (empty($documento) || empty($uci)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../uci.php?documento=' . $documento);

        exit();
    }

    // Actualizar la base de datos con la fecha de pago y el código UCI
    $sql = "UPDATE users SET uci = :uci, lic = 'Activa' WHERE documento = :documento";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':uci', $uci, PDO::PARAM_STR);
    $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Pago registrado correctamente.";
    } else {
        // Obtener información del error
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar el pago: " . $errorInfo[2];
    }

    // Redirigir de vuelta a la página de pagos
    header('Location: ../uci.php');
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos
    header('Location: ../uci.php');
    exit();
}
?>