<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();

// Conexión a la base de datos
include('db.php');
require('email_pago.php');

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documento'];
    $fecha_pago = $_POST['fecha_pago'];
    $uci = $_POST['uci'];

    // Verificar que los datos no estén vacíos
    if (empty($documento) || empty($fecha_pago) || empty($uci)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../pagos.php?documento=' . $documento );

        exit();
    }

    // Actualizar la base de datos con la fecha de pago y el código UCI
    $sql = "UPDATE users SET fecha_pago = :fecha_pago, uci = :uci, lic = 'Activa' WHERE documento = :documento";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':fecha_pago', $fecha_pago, PDO::PARAM_STR);
    $stmt->bindParam(':uci', $uci, PDO::PARAM_STR);
    $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);

    
    if ($stmt->execute()) {
        $sql1 = "SELECT * FROM users WHERE documento = :documento";
        $stmt1 = $conn->prepare($sql1);
        $stmt1->bindParam(':documento', $documento, PDO::PARAM_STR);
        $stmt1->execute();
        $data = $stmt1->fetch(PDO::FETCH_ASSOC);

        $nomcompleto = $data['Nombre'] . ' ' . $data['apellidos'];
        
        emailpago($data['documento'], $nomcompleto, $data['federacion'], $data['licenciaanio'], $data['LicValida'], $data['email'], $data['id']);

        $_SESSION['success_msg'] = "Pago registrado correctamente.";

        


    } else {
        // Obtener información del error
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar el pago: " . $errorInfo[2];
    }

    // Redirigir de vuelta a la página de pagos
    header('Location: ../pagos.php?documento=' . $documento );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos
    header('Location: ../pagos.php?documento=' . $documento );
    exit();
}
?>