<?php
session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');


// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documento'];
    $id_carrera = $_POST['id'];
    $federacion_id_user = $_SESSION['usuario_fedid'];

    $stmt_carrera_user = $conn->prepare("SELECT federacion_id from carreras where id = :id_carrera");
    $stmt_carrera_user->bindParam(':id_carrera', $id_carrera, PDO::PARAM_INT);
    $stmt_carrera_user->execute();
    $carrera = $stmt_carrera_user->fetch(PDO::FETCH_ASSOC);

    if ($carrera['federacion_id'] != $federacion_id_user) {
        $_SESSION['error_msg'] = "No puedes registrar un corredor en una carrera de otra federación." . $carrera['federacion_id'] . " - " . $federacion_id_user;
        header('Location: ../editar_carrera.php?id=' . $id_carrera );
        exit();
    }

    // Verificar que los datos no estén vacíos
    if (empty($id_carrera) || empty($documento)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../editar_carrera.php?id=' . $id_carrera );

        exit();
    }

    // Verificar que el corredor no esté ya registrado en la carrera
    $stmt = $conn->prepare("SELECT * FROM carreras_registros WHERE carrera_id = :id_carrera AND corredor_documento = :documento");
    $stmt->bindParam(':id_carrera', $id_carrera, PDO::PARAM_STR);
    $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $_SESSION['error_msg'] = "El corredor ya está registrado en la carrera.";
        header('Location: ../editar_carrera.php?id=' . $id_carrera );
        exit();
    }



    // Actualizar otra tabla (por ejemplo, pagos)
    $sql2 = "INSERT INTO carreras_registros SET carrera_id = :id_carrera, corredor_documento = :documento";
    $stmt2 = $conn->prepare($sql2);
    $stmt2->bindParam(':id_carrera', $id_carrera, PDO::PARAM_STR);
    $stmt2->bindParam(':documento', $documento, PDO::PARAM_STR);

    $success2 = $stmt2->execute();

    if ($success2) {
        $_SESSION['success_msg'] = "DNI $documento registrado en la carrera.";
       } else {
        // Obtener información del error
        $errorInfo2 = $stmt2->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar el corredor en la carrera: " . $errorInfo2[2];
    }

    // Redirigir de vuelta a la página de pagos masivos
    header('Location: ../editar_carrera.php?id=' . $id_carrera );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos masivos
    header('Location: ../editar_carrera.php?id=' . $id_carrera );
    exit();
}
?>