<?php
session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');


// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documento'];
    $id_carrera = $_POST['id'];
    $federacion_id_user = $_SESSION['usuario_fedid'];
    $pruebas_seleccionadas = $_POST['pruebas'];

    $stmt_carrera_user = $conn->prepare("SELECT u.federacion, u.categoria, f.id from users u join federaciones f on u.federacion = f.federacion where documento = :documento");
    $stmt_carrera_user->bindParam(':documento', $documento, PDO::PARAM_INT);
    $stmt_carrera_user->execute();
    $carrera = $stmt_carrera_user->fetch(PDO::FETCH_ASSOC);
   
// Obtener las categorías asociadas al campeonato
$sql = "SELECT categoria FROM campeonato_cat WHERE id_campeonato = :id_campeonato";
$stmt = $conn->prepare($sql);
$stmt->bindParam(':id_campeonato', $id_carrera, PDO::PARAM_INT);
$stmt->execute();
$categorias_asociadas = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Verificar si la categoría del usuario está en las categorías asociadas
$categorias_asociadas_array = array_column($categorias_asociadas, 'categoria'); // Extrae solo las categorías de la consulta
if (!in_array($carrera['categoria'], $categorias_asociadas_array)) {
    $_SESSION['error_msg'] = "Tu categoría no es apta para este campeonato.";
    header('Location: ../ver_campeonato.php?id=' . $id_carrera);
    exit();
}

    if ($carrera['id'] != $federacion_id_user) {
        $_SESSION['error_msg'] = "No puedes registrar un corredor en una carrera de otra federación." . $carrera['federacion_id'] . " - " . $federacion_id_user;
        header('Location: ../ver_campeonato.php?id=' . $id_carrera );
        exit();
    }

    // Verificar que los datos no estén vacíos
    if (empty($id_carrera) || empty($documento) || empty($pruebas_seleccionadas)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../ver_campeonato.php?id=' . $id_carrera );

        exit();
    }

    // Verificar que el corredor no esté ya registrado en la carrera
    $stmt = $conn->prepare("SELECT * FROM campeonatos_registros WHERE campeonato_id = :id_carrera AND corredor_documento = :documento");
    $stmt->bindParam(':id_carrera', $id_carrera, PDO::PARAM_STR);
    $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $_SESSION['error_msg'] = "El corredor ya está registrado en el campeonato.";
        header('Location: ../ver_campeonato.php?id=' . $id_carrera );
        exit();
    }


 try {
        // Iniciar la transacción
        $conn->beginTransaction();

        // Insertar cada prueba seleccionada en la tabla campeonatos_registros
        foreach ($pruebas_seleccionadas as $id_prueba) {
            $stmt = $conn->prepare("INSERT INTO campeonatos_registros (campeonato_id, corredor_documento, time, id_prueba) VALUES (:campeonato_id, :corredor_documento, NOW(), :id_prueba)");
            $stmt->bindParam(':campeonato_id', $id_carrera, PDO::PARAM_INT);
            $stmt->bindParam(':corredor_documento', $documento, PDO::PARAM_STR);
            $stmt->bindParam(':id_prueba', $id_prueba, PDO::PARAM_INT);
            $stmt->execute();
        }

        // Confirmar la transacción
        $conn->commit();

        // Redirigir o mostrar un mensaje de éxito
        $_SESSION['success_msg'] = 'Corredor registrado con éxito';
        header('Location: ../ver_campeonato.php?id=' . $id_carrera);
    } catch (Exception $e) {
        // Si ocurre un error, revertir la transacción
        $conn->rollBack();
        echo "Error al registrar las pruebas: " . $e->getMessage();
    }
}
?>