<?php
// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];

// Manejo de búsqueda
$stmt_federaciones = $conn->prepare("SELECT id, federacion FROM federaciones WHERE id <> 1");
$stmt_federaciones->execute();
$federaciones = $stmt_federaciones->fetchAll(PDO::FETCH_ASSOC);

// Configuración de paginación
$registros_por_pagina = 20;
$pagina_actual = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$inicio_registro = ($pagina_actual - 1) * $registros_por_pagina;

$registros = [];
$total_paginas = 0;

// Solo ejecutar la consulta si se ha proporcionado un documento
    // Construcción de la consulta con JOIN
    $sql = "
        SELECT federacion, fecha_pago_mas from pagos_masivos
    ";
    // Contar total de registros
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $total_registros = $stmt->rowCount();

    // Calcular total de páginas
    $total_paginas = ceil($total_registros / $registros_por_pagina);

    // Agregar límite para la paginación
    $sql .= " LIMIT $inicio_registro, $registros_por_pagina";

    // Ejecutar consulta con paginación
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $registros = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    


    // Ejecutar consulta con paginación
 
?>