<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();

// Conexión a la base de datos
include('db.php');

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
   
    $fecha_campeonato = $_POST['campeonato_fecha'];
    $lugar_campeonato = $_POST['campeonato_lugar'];
    $nombre_campeonato = $_POST['campeonato_nombre'];



    // Verificar que los datos no estén vacíos
    if (empty($fecha_campeonato) || empty($lugar_campeonato)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../campeonatos.php');

        exit();
    }

    // Actualizar la base de datos con la fecha de pago y el código UCI
    $sql = "INSERT INTO campeonatos (campeonato_fecha, campeonato_lugar, campeonato_nombre) VALUES (:fecha_campeonato, :lugar_campeonato, :nombre_campeonato)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':fecha_campeonato', $fecha_campeonato, PDO::PARAM_STR);
    $stmt->bindParam(':lugar_campeonato', $lugar_campeonato, PDO::PARAM_STR);
    $stmt->bindParam(':nombre_campeonato', $nombre_campeonato, PDO::PARAM_STR);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Campeonato Creado.";
    } else {
        // Obtener información del error
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error_msg'] = "Error crear carrera: " . $errorInfo[2];
    }

    // Redirigir de vuelta a la página de pagos
    header('Location: ../campeonatos.php');
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos
    header('Location: ../campeonatos.php');
    exit();
}
?>