<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();

// Conexión a la base de datos
include('db.php');

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $federacion_id = $_POST['federacion_id'];
    $federacion_carrera = $_POST['federacion_carrera'];
    $fecha_carrera = $_POST['fecha_carrera'];
    $lugar_carrera = $_POST['lugar_carrera'];
    $nombre_carrera = $_POST['nombre_carrera'];



    // Verificar que los datos no estén vacíos
    if (empty($federacion_id) || empty($federacion_carrera)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../carreras.php');

        exit();
    }

    // Actualizar la base de datos con la fecha de pago y el código UCI
    $sql = "INSERT INTO carreras (federacion_carrera, federacion_id, fecha_carrera, lugar_carrera, nombre_carrera, activa) VALUES (:federacion_carrera, :federacion_id, :fecha_carrera, :lugar_carrera, :nombre_carrera, 1)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':federacion_carrera', $federacion_carrera, PDO::PARAM_STR);
    $stmt->bindParam(':federacion_id', $federacion_id, PDO::PARAM_STR);
    $stmt->bindParam(':fecha_carrera', $fecha_carrera, PDO::PARAM_STR);
    $stmt->bindParam(':lugar_carrera', $lugar_carrera, PDO::PARAM_STR);
    $stmt->bindParam(':nombre_carrera', $nombre_carrera, PDO::PARAM_STR);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Carrera creada.";
    } else {
        // Obtener información del error
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error_msg'] = "Error crear carrera: " . $errorInfo[2];
    }

    // Redirigir de vuelta a la página de pagos
    header('Location: ../carreras.php');
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos
    header('Location: ../carreras.php');
    exit();
}
?>