<?php
// Conexión a la base de datos
include('db.php');
session_start();
// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso != 2 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

// Verificar si los datos fueron enviados por POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id_campeonato = $_POST['id_campeonato'];
    $nombres_prueba = $_POST['nombre_prueba']; // Array con los nombres de las pruebas
    $generos = $_POST['genero']; // Array con los géneros
    
    try {
        // Iniciar una transacción para asegurar que todas las inserciones sean atómicas
        $conn->beginTransaction();

        // Preparar la consulta para verificar si la prueba ya existe
        $sql_check = "SELECT COUNT(*) FROM pruebas_campeonatos WHERE id_campeonato = :id_campeonato AND nombre_prueba = :nombre_prueba";
        $stmt_check = $conn->prepare($sql_check);
        $stmt_check->bindParam(':id_campeonato', $id_campeonato, PDO::PARAM_INT);

        // Asegurarse de que ambos arrays tengan la misma longitud
        $total_pruebas = count($nombres_prueba);
        for ($i = 0; $i < $total_pruebas; $i++) {
            $nombre_prueba = $nombres_prueba[$i];
            $genero = $generos[$i]; // Obtener el género correspondiente

            // Verificar si la prueba ya existe para este campeonato
            $stmt_check->bindParam(':nombre_prueba', $nombre_prueba, PDO::PARAM_STR);
            $stmt_check->execute();

            // Si la prueba ya existe, no insertar
            if ($stmt_check->fetchColumn() > 0) {
                continue; // La prueba ya existe, no hacemos nada
            }

            // Si la prueba no existe, insertarla
            $sql_insert = "INSERT INTO pruebas_campeonatos (id_campeonato, nombre_prueba, genero) VALUES (:id_campeonato, :nombre_prueba, :genero)";
            $stmt_insert = $conn->prepare($sql_insert);
            $stmt_insert->bindParam(':id_campeonato', $id_campeonato, PDO::PARAM_INT);
            $stmt_insert->bindParam(':nombre_prueba', $nombre_prueba, PDO::PARAM_STR);
            $stmt_insert->bindParam(':genero', $genero, PDO::PARAM_STR);
            $stmt_insert->execute();
        }

        // Confirmar la transacción
        $conn->commit();
        $_SESSION['success_msg'] = 'Campeonato modificado con éxito';
        header('Location: ../editar_campeonato.php?id=' . $id_campeonato);
    } catch (Exception $e) {
        // Si ocurre un error, revertir la transacción
        $conn->rollBack();
        echo "Error al guardar las pruebas: " . $e->getMessage();
    }
}
?>
