<?php
// Conexión a la base de datos
include('db.php');
session_start();
// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $opseguro = $_POST['opseguro'];

    try {
        // Iniciar una transacción para asegurar que todas las inserciones sean atómicas
        $conn->beginTransaction();

        // Preparar la consulta para verificar si la prueba ya existe
        $sql_check = "SELECT COUNT(*) FROM opseguro WHERE opseguro = :opseguro";
        $stmt_check = $conn->prepare($sql_check);

        // Asegurarse de que ambos arrays tengan la misma longitud
        $total_pruebas = count($opseguro);
        for ($i = 0; $i < $total_pruebas; $i++) {
            $opseguro_value = $opseguro[$i];

            // Verificar si la prueba ya existe para este campeonato
            $stmt_check->bindParam(':opseguro', $opseguro_value, PDO::PARAM_STR); // Cambiado a PARAM_STR
            $stmt_check->execute();

            // Si la prueba ya existe, no insertar
            if ($stmt_check->fetchColumn() > 0) {
                continue; // La prueba ya existe, no hacemos nada
            }

            // Si la prueba no existe, insertarla
            $sql_insert = "INSERT INTO opseguro (opseguro) VALUES (:opseguro)";
            $stmt_insert = $conn->prepare($sql_insert);
            $stmt_insert->bindParam(':opseguro', $opseguro_value, PDO::PARAM_STR); // Cambiado a PARAM_STR
            $stmt_insert->execute();
        }

        // Confirmar la transacción
        $conn->commit();
        $_SESSION['success_msg'] = 'Opciones de seguro guardadas con éxito';
        header('Location: ../opseguro.php');
    } catch (Exception $e) {
        // Si ocurre un error, revertir la transacción
        $conn->rollBack();
        echo "Error al guardar las opciones de seguro: " . $e->getMessage();
    }
}
?>
