<?php
// Configuración de la base de datos
require 'config/db.php'; // Esto ya te conecta a la base de datos y guarda la conexión en $conn
require '../vendor/autoload.php';  // Asegúrate de que el path al autoload sea correcto
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
// Consulta para obtener el valor máximo de 'lic'
$stmt = $conn->prepare("SELECT MAX(licencia) AS max_licencia FROM users");
$stmt->execute();
$result = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener el valor máximo de 'lic' y establecer $lic_sig
$max_lic = $result['max_licencia'];
if($max_lic > 299) {
    $lic_sig = $max_lic + 1;
} else {
    $lic_sig = 300;
}

// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];


// Usamos la variable $conn para las consultas
$datos = null;
$show_popup = false;
$modified_data = []; // Array para almacenar los datos modificados
$usuario_registrado = false; // Flag para verificar si el usuario ya está registrado

$stmt_federaciones = $conn->prepare("SELECT id, federacion FROM federaciones WHERE id <> 1");
$stmt_federaciones->execute();
$federaciones = $stmt_federaciones->fetchAll(PDO::FETCH_ASSOC);

$stmt_clubs = $conn->prepare("SELECT club FROM clubs ORDER BY club ASC");
$stmt_clubs->execute();
$clubs = $stmt_clubs->fetchAll(PDO::FETCH_ASSOC);
                
$stmt_opseguro = $conn->prepare("SELECT opseguro FROM opseguro ORDER BY opseguro ASC");
$stmt_opseguro->execute();
$opseguros = $stmt_opseguro->fetchAll(PDO::FETCH_COLUMN);


$stmt_anios = $conn->prepare("SELECT * FROM anios");
$stmt_anios->execute();
$anios = $stmt_anios->fetch(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar si el documento ya existe en la base de datos
    $documento = $_POST['documento'];
    $email = $_POST['email'];
    $stmt = $conn->prepare("SELECT COUNT(*) FROM users WHERE documento = :documento");
    $stmt->execute([':documento' => $documento]);
    $count = $stmt->fetchColumn();
    $fechanac = $_POST['fechanac'];
    $fecha_formateada = date("d/m/Y", strtotime($fechanac)); // Convierte yyyy-mm-dd a dd/mm/yyyy
    $categoria0 = $_POST['categoria0'];
    $categoria1 = isset($_POST['categoria1']) && !empty($_POST['categoria1']) ? $_POST['categoria1'] : null;
    $categoriaConcatenada = $categoria1 ? $categoria0 . ' - ' . $categoria1 : $categoria0;
    $fecha_registro = date("Y-m-d H:i:s");
    $fecha_federado = date("Y-m-d H:i:s");
    
    
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
        // Obtener información del archivo subido
        $fileTmpPath = $_FILES['foto']['tmp_name'];
        $fileName = $_FILES['foto']['name'];
        $fileSize = $_FILES['foto']['size'];
        $fileType = $_FILES['foto']['type'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));
    
        // Establecer el nombre del archivo como documento.png
        $newFileName = $documento . '.png';
    
        // Establecer la ruta de destino
        $uploadFileDir = '../fotos/';
        $dest_path = $uploadFileDir . $newFileName;
    
        // Mover el archivo subido a la ubicación de destino
        if(move_uploaded_file($fileTmpPath, $dest_path)) {
            echo "El archivo se ha subido correctamente.";
        } else {
            echo "Hubo un error al mover el archivo subido.";
        }
    } else {
        echo "No se ha subido ningún archivo.";
    }
    
   
// Preparar la consulta para verificar si el email ya existe y no es del mismo documento
$stmt_email = $conn->prepare("SELECT COUNT(*) FROM users WHERE email = :email AND documento != :documento");
$stmt_email->bindParam(':email', $email, PDO::PARAM_STR);  // Asignar valor al parámetro :email
$stmt_email->bindParam(':documento', $documento, PDO::PARAM_STR);  // Asignar valor al parámetro :documento

// Ejecutar la consulta
$stmt_email->execute();

// Obtener el número de registros que coinciden
$email_exists = $stmt_email->fetchColumn();  // Usamos fetchColumn() para obtener el valor de la primera columna

if ($email_exists > 0) {
    // Si el email ya existe, mostrar un mensaje de error y redirigir
    $_SESSION['error_msg'] = 'El correo electrónico ya está registrado. Por favor, utiliza otro.';
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;
}




    if ($count > 0) {
        // Si el documento ya existe, proceder con la actualización
    
        
        
        $sql = "UPDATE users SET 
               vacunado = :vacunado, 
                peso = :peso, altura = :altura, os = :os, categoria = :categoria, 
                club = :club, ciudad = :ciudad, calle = :calle, 
                opseguro = :opseguro, telefono = :telefono, email = :email, emergencia = :emergencia, 
                telemergencia = :telemergencia, emailcontacto = :emailcontacto, licenciaanio = :licenciaanio, lic = :lic, fecha_registro = :fecha_registro 
                , federacion = :federacion, licencia = :licencia, federado = 1, fecha_federado = :fecha_federado WHERE documento = :documento";
    } else {
        // Si no existe, realizar la inserción
        $sql = "INSERT INTO users (documento, uci, Nombre, apellidos, genero, vacunado, peso, altura, os, fechanac, 
                categoria, club, ciudad, calle, nacionalidad, opseguro, telefono, email, emergencia, 
                telemergencia, emailcontacto, licenciaanio, lic, fecha_registro, federacon, licencia) 
                VALUES (:documento, :uci, :Nombre, :apellidos, :genero, :vacunado, :peso, :altura, :os, :fechanac, 
                :categoria, :club, :ciudad, :calle, :nacionalidad, :opseguro, :telefono, :email, :emergencia, 
                :telemergencia, :emailcontacto, :licenciaanio, :lic, :fecha_registro, :federacion, :licencia)";
    }
    
    
    // Preparar la consulta
    $stmt = $conn->prepare($sql);

    // Ejecutar la consulta con los datos
    $stmt->execute([
        ':documento' => $_POST['documento'],
        ':vacunado' => $_POST['vacunado'],
        ':peso' => $_POST['peso'],
        ':altura' => $_POST['altura'],
        ':os' => $_POST['os'],
        ':categoria' => $categoriaConcatenada,
        ':club' => $_POST['club'],
        ':ciudad' => $_POST['localidad'] . ' - ' . $_POST['provincia'],
        ':calle' => $_POST['calle'],
        ':opseguro' => $_POST['opseguro'],
        ':telefono' => $_POST['telefono'],
        ':email' => $_POST['email'],
        ':emergencia' => $_POST['emergencia'],
        ':telemergencia' => $_POST['telemergencia'],
        ':licenciaanio' => $_POST['licenciaanio'],
        ':emailcontacto' => $_POST['emailcontacto'],
        ':fecha_registro' => $fecha_registro,
        ':lic' => 'Licenciamiento pendiende de autorización',
        ':federacion' => $federacion_usuario,
        ':licencia' => $lic_sig,
        ':fecha_federado' => $fecha_federado,
    ]);
        

    
    $labels = [
    'uci' => 'Código UCI',
    'Nombre' => 'Nombre',
    'apellidos' => 'Apellidos',
    'genero' => 'Género',
    'vacunado' => 'Vacunado COVID',
    'peso' => 'Peso',
    'altura' => 'Altura',
    'os' => 'Obra Social',
    'fechanac' => 'Fecha de Nacimiento',
    'categoria' => 'Categoría',
    'club' => 'Club',
    'localidad' => 'Localidad',
    'provincia' => 'Provincia',
    'calle' => 'Calle',
    'nacionalidad' => 'Nacionalidad',
    'opseguro' => 'Opción Seguro',
    'telefono' => 'Teléfono',
    'email' => 'Email',
    'emergencia' => 'Emergencia',
    'telemergencia' => 'Teléfono de Emergencia',
    'emailcontacto' => 'Email de Contacto',
    'licenciaanio' => 'Licencia Año',
    'licencia' => 'Licencia n°',
    'federacion' => 'Federación'
];

    // Almacenar los datos modificados para mostrar en el popup
    $modified_data = [
        //'uci' => $_POST['uci'],
        'Nombre' => $_POST['Nombre'],
        'apellidos' => $_POST['apellidos'],
        //'genero' => $_POST['genero'],
        //'vacunado' => $_POST['vacunado'],
       // 'peso' => $_POST['peso'],
      //  'altura' => $_POST['altura'],
       // 'os' => $_POST['os'],
      //  'fechanac' => $fecha_formateada,
        'categoria' => $categoriaConcatenada,
     //   'club' => $_POST['club'],
       // 'localidad' => $_POST['localidad'],
       // 'provincia' => $_POST['provincia'],
       // 'calle' => $_POST['calle'],
       // 'nacionalidad' => $_POST['nacionalidad'],
       // 'opseguro' => $_POST['opseguro'],
      //  'telefono' => $_POST['telefono'],
      //  'email' => $_POST['email'],
     //   'emergencia' => $_POST['emergencia'],
      //  'telemergencia' => $_POST['telemergencia'],
        'licenciaanio' => $_POST['licenciaanio'],
       // 'emailcontacto' => $_POST['emailcontacto'],
       'federacion' => $federacion_usuario,
       'licencia' => $lic_sig

    ];

    // Mostrar el popup después de la modificación
    $show_popup = true;


//EMAIL - no te olvides de arriba
$nombre = $_POST['Nombre'];
$apellidos = $_POST['apellidos'];
$email = $_POST['email'];
$telefono = $_POST['telefono'];
$federacion = $federacion_usuario;
$categoria = $_POST['categoria0'];
$subCategoria = $_POST['categoria1'];
$peso = $_POST['peso'];
$altura = $_POST['altura'];
$vacunado = $_POST['vacunado'];
$club = $_POST['club'];
$localidad = $_POST['localidad'];
$provincia = $_POST['provincia'];
$calle = $_POST['calle'];
$emergencia = $_POST['emergencia'];
$telemergencia = $_POST['telemergencia'];
$emailEmergencia = $_POST['emailcontacto'];
$anio = $_POST['licenciaanio'];
// Crear el mensaje del correo con los valores de los campos
$mensaje = "
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            padding: 20px;
            width: 35em;
        }
        ul {
            list-style-type: none;
            padding: 0;
        }
        li {
            margin: 10px 0;
            padding: 10px;
            background-color: #f9f9f9;
            border-radius: 5px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        li:nth-child(even) {
            background-color: #f1f1f1;
        }
        strong {
            color:rgb(63, 105, 150);
        }
    </style>
</head>
<body style='width:50%'>
    <h2>Datos Corredor:</h2>
    <ul>
        <li><strong>Federación:</strong> " . htmlspecialchars($federacion_usuario) . "</li>
        <li><strong>Nombre:</strong> " . htmlspecialchars($nombre) . " " . htmlspecialchars($apellidos) . "</li>
        <li><strong>Email:</strong> " . htmlspecialchars($email) . "</li>
        <li><strong>Teléfono:</strong> " . htmlspecialchars($telefono) . "</li>
        <li><strong>Categoría:</strong> " . htmlspecialchars($categoria) . "</li>
        <li><strong>Subcategoría:</strong> " . htmlspecialchars($subCategoria) . "</li>
        <li><strong>Peso:</strong> " . htmlspecialchars($peso) . "</li>
        <li><strong>Altura:</strong> " . htmlspecialchars($altura) . "</li>
        <li><strong>Vacunado COVID:</strong> " . htmlspecialchars($vacunado) . "</li>
        <li><strong>Club:</strong> " . htmlspecialchars($club) . "</li>
        <li><strong>Localidad:</strong> " . htmlspecialchars($localidad) . "</li>
        <li><strong>Provincia:</strong> " . htmlspecialchars($provincia) . "</li>
        <li><strong>Calle:</strong> " . htmlspecialchars($calle) . "</li>
        <li><strong>Emergencia:</strong> " . htmlspecialchars($emergencia) . "</li>
        <li><strong>Teléfono Emergencia:</strong> " . htmlspecialchars($telemergencia) . "</li>
        <li><strong>Email Emergencia:</strong> " . htmlspecialchars($emailEmergencia) . "</li>
    </ul>
</body>
</html>";



try {
    
       // Crear una instancia de PHPMailer
       $mail = new PHPMailer(true); 

       // Configuración del servidor SMTP
   $mail->isSMTP();  // Configurar el correo para usar SMTP
    $mail->Host = 'ci1.toservers.com';  // Servidor SMTP (en este caso Gmail)
    $mail->Username = 'licenciamiento@ciclismoarg.com';
       $mail->Password = 'r3aBxFPf&M26';  // Tu contraseña de Gmail (o usar "contraseñas de aplicaciones" si tienes habilitada la verificación en dos pasos)
       $mail->SMTPSecure = 'ssl'; 
       $mail->SMTPAuth = true;     
       $mail->Port = 465;  //o 465    
       $mail->CharSet = 'UTF-8';
       // Remitente y destinatario
       $mail->setFrom('licenciamiento@ciclismoarg.com', htmlspecialchars('FAC en Pista y Ruta'));
       $mail->addAddress($email, $nombre); // Agregar un destinatario
       $mail->addCC($_SESSION['email'], $federacion_usuario); 
       $mail->addReplyTo('licenciamiento@ciclismoarg.com', htmlspecialchars('FAC en Pista y Ruta'));  // Responder a este correo (opcional)

    // Contenido del correo
    $mail->isHTML(true);  // Establecer el formato de correo a HTML
    $mail->Subject = htmlspecialchars('Ciclista Federado - ' . htmlspecialchars($nombre) . " " . htmlspecialchars($apellidos) ." ". $documento . ' - '. $anio);
    $mail->Body    = '            <img src="https://ciclismoarg.com.ar/licencias/logo2.jpeg" alt="Logo" height="150">

    <br style="margin-top:20px">
    <h3>La federación ' . $federacion_usuario . ' ha resgistrado a ' . htmlspecialchars($nombre) . " " . htmlspecialchars($apellidos) . ' - ' . $documento . ' para el año ' . $anio . '.</h3>
    <br style="margin-top:20px">
    <p>Cuando la asociación realice el depósito a FACPyR, se verá reflejado en la emisión de la licencia.</p>
    <br style="margin-top:20px">'
    . $mensaje .
    '<br style="margin-top:20px">
    <img src="https://ciclismoarg.com.ar/licencias/logo2.jpeg" alt="Logo" height="150">
    ';
    $mail->AltBody = strip_tags($mensaje);

    // Enviar el correo
    if ($mail->send()) {
        echo 'El mensaje ha sido enviado con éxito';
    } else {
        echo 'No se pudo enviar el mensaje.';
    }
} catch (Exception $e) {
    // Si ocurre algún error
    echo "El mensaje no pudo ser enviado. Error: {$mail->ErrorInfo}";
}



}























// Acción de recuperar datos según el documento
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['documento'])) {
    // Recuperar el valor de documento
    $documento = trim($_GET['documento']);  // Eliminar espacios innecesarios

    // Recuperar datos desde la base de datos
    $stmt = $conn->prepare("SELECT * FROM users WHERE documento = :documento");
    $stmt->execute([':documento' => $documento]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);




    if ($user) {
        // Verificar si el valor de licenciaanio coincide con la tabla anios
        $stmt_licencia = $conn->prepare("SELECT * FROM anios WHERE licenciaanio = :licenciaanio");
        $stmt_licencia->execute([':licenciaanio' => $user['licenciaanio']]);
        $licencia = $stmt_licencia->fetch(PDO::FETCH_ASSOC);

        if ($licencia) {
            // Si la licencia coincide, mostrar mensaje y no mostrar formulario
            $usuario_registrado = false;
            $datos = $user;  // No se necesitan los datos del usuario si ya está registrado
        } else {
            $datos = $user;
        }
    } else {
        $datos = null;
    }
}

?>