document.getElementById('email').addEventListener('input', function(event) {
    const email = event.target.value;

    // Verificar si el email y documento no están vacíos antes de hacer la petición
    if (email && documento1) {
        checkEmailExistence(email, documento1); // Enviar tanto el email como el documento
    } else {
        // Si el campo email está vacío o el documento también, ocultamos el mensaje de error
        document.getElementById('email-error').style.display = 'none';
    }
});

function checkEmailExistence(email, documento) {
    const emailErrorDiv = document.getElementById('email-error');
    const boton = document.getElementById('enviarreg');

    // Llamada AJAX para verificar si el email existe y si está asociado al documento
    fetch('admin/config/check_email.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ email: email, documento: documento }) // Enviar email y documento al servidor
    })
    .then(response => response.json())
    .then(data => {
        if (data.exists) {
            if (data.can_upload) {
                // Si el email está asociado con el documento, no hacemos nada
                emailErrorDiv.style.display = 'none';
                boton.style.display = 'inline';
            } else {
                // Si el email existe pero está asociado con otro documento, mostramos el error
                emailErrorDiv.style.display = 'block';
                emailErrorDiv.textContent = 'Este correo ya está registrado, pero no está asociado al documento.';
                boton.style.display = 'none';
            }
        } else {
            // Si el email no existe en absoluto, no hacemos nada
            emailErrorDiv.style.display = 'none';
                            boton.style.display = 'inline';

        }
    })
    .catch(error => {
        console.error('Error al verificar el correo:', error);
    });
}
