<?php
// Conexión a la base de datos
include('db.php');
session_start();
// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];


// Verificar el nivel de acceso
if ($nivel_acceso != 2 ) { // Cambia este valor según el nivel de acceso requerido
    $_SESSION['error_message'] = "Acceso denegado. Nivel de acceso insuficiente.";
    header("Location: index.php");
    exit();
}
// Verificar si se ha enviado el ID de la prueba a eliminar
if (isset($_POST['id'])) {
    $id_prueba = $_POST['id'];

    // Preparar la consulta para eliminar la prueba
    $sql = "DELETE FROM pruebas_campeonatos WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':id', $id_prueba, PDO::PARAM_INT);

    // Ejecutar la consulta
    if ($stmt->execute()) {
        echo "Prueba eliminada correctamente.";
    } else {
        echo "Error al eliminar la prueba.";
    }
} else {
    echo "No se recibió el ID de la prueba.";
}
?>
