<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();

// Conexión a la base de datos
include('db.php');

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $federacion = $_POST['federacion'];
    $fecha_pago = $_POST['fecha_pago_mas'];

    // Verificar que los datos no estén vacíos
    if (empty($fecha_pago) || empty($federacion)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../pagos_master.php' );

        exit();
    }

    $sql1 = "UPDATE users SET fecha_pago = null, lic = 'Licenciamiento pendiende de autorización' WHERE federacion = :federacion AND fecha_pago = :fecha_pago";
    $stmt1 = $conn->prepare($sql1);
    $stmt1->bindParam(':fecha_pago', $fecha_pago, PDO::PARAM_STR);
    $stmt1->bindParam(':federacion', $federacion, PDO::PARAM_STR);

    $success1 = $stmt1->execute();

    // Actualizar otra tabla (por ejemplo, pagos)
    $sql2 = "DELETE FROM pagos_masivos WHERE fecha_pago_mas = :fecha_pago and federacion = :federacion";
    $stmt2 = $conn->prepare($sql2);
    $stmt2->bindParam(':fecha_pago', $fecha_pago, PDO::PARAM_STR);
    $stmt2->bindParam(':federacion', $federacion, PDO::PARAM_STR);

    $success2 = $stmt2->execute();

    if ($success1 && $success2) {
        $_SESSION['success_msg'] = "Pago registrado correctamente.";
    } else {
        // Obtener información del error
        $errorInfo1 = $stmt1->errorInfo();
        $errorInfo2 = $stmt2->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar el pago: " . $errorInfo1[2] . " / " . $errorInfo2[2];
    }

    // Redirigir de vuelta a la página de pagos masivos
    header('Location: ../pagos_master.php');
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos masivos
    header('Location: ../pagos_master.php');
    exit();
}
?>