<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();

// Conexión a la base de datos
include('db.php');

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documento'];

    // Verificar que los datos no estén vacíos
    if (empty($documento) ){
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../pagos.php?documento=' . $documento );

        exit();
    }

    // Actualizar la base de datos con la fecha de pago y el código UCI
    $sql = "UPDATE users SET fecha_pago = null, lic = 'Licenciamiento pendiende de autorización' WHERE documento = :documento";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Pago registrado correctamente.";
    } else {
        // Obtener información del error
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar el pago: " . $errorInfo[2];
    }

    // Redirigir de vuelta a la página de pagos
    header('Location: ../pagos.php?documento=' . $documento );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos
    header('Location: ../pagos.php?documento=' . $documento );
    exit();
}
?>