<?php
session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');
// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    
    
     $id_carrera = $_POST['id'];
// Verificar el nivel de acceso
if ($nivel_acceso == 2 ) { // Cambia este valor seg煤n el nivel de acceso requerido

    // Obtener los datos del formulario
    $documento = $_POST['documento'];
    $id_carrera = $_POST['id'];
    $federacion_id_user = $_SESSION['usuario_fedid'];


    $stmt_carrera_user = $conn->prepare("SELECT u.federacion, f.id from users u join federaciones f on u.federacion = f.federacion where documento = :documento");
    $stmt_carrera_user->bindParam(':documento', $documento, PDO::PARAM_INT);
    $stmt_carrera_user->execute();
    $carrera = $stmt_carrera_user->fetch(PDO::FETCH_ASSOC);
   
if ($nivel_acceso <> 2 ) { 
    if ($carrera['id'] != $federacion_id_user) {
        $_SESSION['error_msg'] = "No puedes registrar un corredor en una carrera de otra federación." . $carrera['federacion_id'] . " - " . $federacion_id_user;
        header('Location: ../ver_campeonato.php?id=' . $id_carrera );
        exit();
    }
}

    // Verificar que los datos no estén vacíos
    if (empty($id_carrera) || empty($documento)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../ver_campeonato.php?id=' . $id_carrera );

        exit();
    }



 try {
        // Iniciar la transacción
        $conn->beginTransaction();


            $stmt = $conn->prepare("DELETE FROM campeonatos_registros WHERE corredor_documento = :corredor_documento and campeonato_id = :campeonato_id");
            $stmt->bindParam(':campeonato_id', $id_carrera, PDO::PARAM_INT);
            $stmt->bindParam(':corredor_documento', $documento, PDO::PARAM_STR);
            $stmt->execute();
    

        // Confirmar la transacción
        $conn->commit();

        // Redirigir o mostrar un mensaje de éxito
        $_SESSION['success_msg'] = 'Corredor Eliminado del campeonato';
        header('Location: ../ver_campeonato.php?id=' . $id_carrera);
    } catch (Exception $e) {
        // Si ocurre un error, revertir la transacción
        $conn->rollBack();
        echo "Error al registrar: " . $e->getMessage();
    }
}
else
{
        $_SESSION['error_message'] = "Acceso denegado. No puedes elimianr corredores.";
    header("Location: https://ciclismoarg.com/licencias/admin/ver_campeonato.php?id=" . $id_carrera );
    exit();
}

}
?>