<?php
session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');


// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documento'];
    $id = $_POST['id'];
    

      // Actualizar otra tabla (por ejemplo, pagos)
    $sql2 = "DELETE FROM autorizaciones WHERE id = :id";
    $stmt2 = $conn->prepare($sql2);

    $stmt2->bindParam(':id', $id, PDO::PARAM_STR);

    $success2 = $stmt2->execute();

    if ($success2 ) {
        $_SESSION['success_msg'] = "Autoización Eliminada.";
       } else {
        // Obtener información del error
        $errorInfo2 = $stmt2->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar la autorización " . $errorInfo2[2];
    }

    // Redirigir de vuelta a la página de pagos masivos
    header('Location: ../autorizaciones.php' );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos masivos
    header('Location: ../autorizaciones.php' );
    exit();
}
?>